import javax.servlet.*;
import javax.servlet.http.*;

import java.io.*;
import java.sql.*;

import ap.servlets.*;

public class sales extends HttpServlet {

  Connection dbCon;

  public void init() throws ServletException {

    /* Connect to the database */
    try{
      String driver = getInitParameter("JdbcDriver");
      String dbURL = getInitParameter("dbURL");
      Class.forName(driver);
      dbCon = DriverManager.getConnection(dbURL);
    }
    catch(ClassNotFoundException e) {
      System.out.println("sales: Database driver could not be found.");
      System.out.println(e.toString());
      throw new UnavailableException(this, "Database driver class not found");
    }
    catch(SQLException e) {
      System.out.println("sales: Error connecting to the database.");
      System.out.println(e.toString());
      throw new UnavailableException(this, "Cannot connect to the database");
    }

  }

  public void doPost(HttpServletRequest _req, HttpServletResponse _res)
    throws ServletException, IOException {

    _res.setContentType("text/html");
    PrintWriter out = _res.getWriter();

    String sales[][] = new String[5][3];

    sales[0][0] = "North";
    sales[0][1] = _req.getParameter("qty_n");
    sales[0][2] = _req.getParameter("rev_n");

    sales[1][0] = "South";
    sales[1][1] = _req.getParameter("qty_s");
    sales[1][2] = _req.getParameter("rev_s");

    sales[2][0] = "East";
    sales[2][1] = _req.getParameter("qty_e");
    sales[2][2] = _req.getParameter("rev_e");

    sales[3][0] = "West";
    sales[3][1] = _req.getParameter("qty_w");
    sales[3][2] = _req.getParameter("rev_w");

    sales[4][0] = "Central";
    sales[4][1] = _req.getParameter("qty_c");
    sales[4][2] = _req.getParameter("rev_c");

    try {
      StringBuffer sql = new StringBuffer(512);
      sql.append("INSERT INTO dailySales(region, [date], qtySold, revenue) ");
      sql.append("VALUES(?,?,?,?)");
      PreparedStatement stmt = dbCon.prepareStatement(sql.toString());
      for (int i = 0; i < 5; i++) {
        stmt.clearParameters();
        stmt.setString(1, sales[i][0]);
        stmt.setDate(2, new java.sql.Date(System.currentTimeMillis()));
        stmt.setInt(3, Integer.parseInt(sales[i][1]));
        stmt.setDouble(4, Double.parseDouble(sales[i][2]));
        stmt.executeUpdate();
      }
    }
    catch (SQLException e) {
      _res.sendError(_res.SC_ACCEPTED, "The request has been accepted, but it failed to complete due to an error updating the database.");
      System.out.println(e.toString());
      return;
    }
    catch (NumberFormatException e) {
      _res.sendError(_res.SC_BAD_REQUEST, "At least one of the input fields is non-numeric. Please correct and try again.");
      System.out.println(e.toString());
      return;
    }

    html h = new html("Widget Sales Update");
    h.add(html.HEADING, "Sales figures have been updated.", false);
    out.println(h.getPage());
    out.close();
  }

  public void destroy() {

    /* Disconnect from the database */
    try{
      dbCon.close();
    }
    catch(Exception e) {
      System.out.println("sales: Database close failed");
      System.out.println(e.toString());
    }

  }

}
