import javax.mail.*;
import javax.mail.internet.*;

public class SendMailExample {

   public static void main(String[] args)
      throws MessagingException {
      if (args.length < 3) {
         System.out.println(
            "Usage: java SendMailExample smtpHost fromAddress " +"toAddress");
         System.exit(1);
      }

      String smtpHost = args[0];
      String from = args[1];
      String to = args[2];

      // Start a session
      java.util.Properties properties = System.getProperties();
      Session session = Session.getInstance(properties, null);

      // Construct a message
      MimeMessage message = new MimeMessage(session);
      message.setFrom(new InternetAddress(from));
      message.addRecipient(Message.RecipientType.TO, 
      new InternetAddress(to));
      message.setSubject("JavaMail example");
      message.setText("Did it work?");

      // Connect to the transport
      Transport transport = session.getTransport("smtp");
      transport.connect(smtpHost, "", "");

      // Send the message and close the connection
      transport.sendMessage(message, message.getAllRecipients());
      transport.close();
   }
}
