import javax.mail.*;
import javax.mail.internet.*;

import javax.servlet.*;
import javax.servlet.http.*;

public class SendMail extends HttpServlet {

   private String smtpHost;

   // Initialize the servlet with the hostname of the SMTP server
   // we'll be using the send the messages

   public void init(ServletConfig config)
   throws ServletException {
      super.init(config);

      smtpHost = config.getInitParameter("smtpHost");
   }

   public void doPost(
      HttpServletRequest request,
      HttpServletResponse response
   )
   throws ServletException, java.io.IOException {
      String from = request.getParameter("from");
      String to = request.getParameter("to");
      String cc = request.getParameter("cc");
      String bcc = request.getParameter("bcc");
      String subject = request.getParameter("subject");
      String text = request.getParameter("text");

      String status;

      try {	
         // Create the JavaMail session
         java.util.Properties properties = System.getProperties();
         properties.put("mail.smtp.host", smtpHost);
         Session session = 
         Session.getInstance(properties, null);

         // Construct the message
         MimeMessage message = new MimeMessage(session);

         // Set the from address
         Address fromAddress = new InternetAddress(from);
         message.setFrom(fromAddress);

         // Parse and set the recipient addresses
         Address[] toAddresses = InternetAddress.parse(to);
         message.setRecipients(Message.RecipientType.TO,toAddresses);

 
         Address[] ccAddresses = InternetAddress.parse(cc);
         message.setRecipients(Message.RecipientType.CC,ccAddresses);

         Address[] bccAddresses = InternetAddress.parse(bcc);
         message.setRecipients(Message.RecipientType.BCC,bccAddresses);

         // Set the subject and text
         message.setSubject(subject);
         message.setText(text);

         Transport.send(message);

         status = "Your message was sent.";

         } catch (AddressException e) {
            status = "There was an error parsing the addresses.";
         } catch (SendFailedException e) {
            status = "There was an error sending the message.";
         } catch (MessagingException e) {
         status = "There was an unexpected error.";
         }

      // Output a status message
      response.setContentType("text/html");

      java.io.PrintWriter writer = response.getWriter();

      writer.println("<html><head><title>Status</title></head>");
      writer.println("<body><p>" + status + "</p></body></html>");

      writer.close();
   }
}
