package tapir.weeds;

import tapir.weeds.representation.*;
import java.sql.*;
import java.io.*;
import java.util.Vector;

import honeylocust.msxml.om.*;
import honeylocust.msxml.parser.*;

public class DBSpecies /* implements Species */ {

  public final Weeds d_w;
  public final String d_id;
  public final String d_oldId; /* no transactional integrity but WTF */
  /* Can we make the new ordering read-only ? */

  public DBSpecies(Weeds w,String id) throws SQLException {
    d_w=w;
    d_id=id;
    d_oldId=w.getOldId(d_id);
  };

  public String getId() {
    return d_id;
  };

  public String getOldId() {
    return d_oldId;
  };

  public LanguageString getFamily() throws SQLException {
    ResultSet rs=d_w.selectFromSpecies(d_oldId);
    return new LanguageString(rs.getString(1),"la");
  };

  public LanguageString[] getLatin() throws SQLException {
    ResultSet rs=d_w.selectFromLatin(d_oldId);
    Vector v=new Vector();
    while(rs.next()) {
      v.addElement(new LanguageString(rs.getString(1),"la"));
    };
    
    LanguageString names[]=new LanguageString[v.size()];
    v.copyInto(names);
    return names;
  };

  public LanguageString[] getCommon() throws SQLException {
    ResultSet rs=d_w.selectFromCommon(d_oldId);
    Vector v=new Vector();
    while(rs.next()) {
      v.addElement(new LanguageString(rs.getString(1),rs.getString(2)));
    };
    
    LanguageString names[]=new LanguageString[v.size()];
    v.copyInto(names);
    return names;
  };

  public Text[] getTexts() throws SQLException,ParseException {
    ResultSet rs=d_w.selectFromTexts(d_oldId);
    Vector v=new Vector();
    while(rs.next()) {
      v.addElement(parseText(rs.getString(1),rs.getString(2),rs.getString(3),rs.getString(4)));
    };
    
    Text texts[]=new Text[v.size()];
    v.copyInto(texts);
    return texts;
  };

  public static Text parseText(String type,String source,String language,String xmlBody) throws ParseException {
    StringBuffer xml=new StringBuffer();
    xml.append("<?XML VERSION=\"1.0\"?>\n");
    xml.append("<!DOCTYPE TEXT SYSTEM \"file:/home/paul/identified-weeds/limon.dtd\">\n");
    xml.append("<TEXT TYPE=\"");
    xml.append(type);
    xml.append("\" SOURCE=\"");
    xml.append(source);
    xml.append("\" xml:lang=\"");
    xml.append(language);
    xml.append("\">\n");
    xml.append(xmlBody);
    xml.append("</TEXT>");

    StringBufferInputStream feed=new StringBufferInputStream(xml.toString());
    Document d=new Document();
    d.setLoadExternal(true);
    d.load(feed);
    
    Element root=d.getRoot();

    return MSXMLSpeciesFactory.parseText(root);
  };

  public static void main(String argv[]) throws Exception {
    String id=argv[0];

    Weeds w=new Weeds();
    DBSpecies d=new DBSpecies(w,id);

    System.out.println("Id:"+id);
    System.out.println("Family: "+d.getFamily());
    System.out.print("Latin: ");
    LanguageString names[]=d.getLatin();
    for(int i=0;i<names.length;i++)
      System.out.println(names[i]);

    System.out.print("Common: ");
    names=d.getCommon();
    for(int i=0;i<names.length;i++)
      System.out.println(names[i]);

    System.out.println("Retreiving texts...");
    Text[] texts=d.getTexts();
  };

};










