package tapir.weeds;

import java.io.*;
import java.sql.*;
import javax.servlet.http.*;
import javax.servlet.*;


public class ViewWeed extends HttpServlet { 

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
	try {
	    String path=req.getPathInfo().substring(1);
	    if (path.endsWith("/")) {
		path=path.substring(0,path.length()-1);
	    };
	    
	    if (path.length()>6 && path.substring(0,6).equals("small/")) {
		serveImage(res,"small",path.substring(6));
		
	    } else if (path.length()>4 && path.substring(0,4).equals("big/")) {
		serveImage(res,"big",path.substring(4));
		
	    } else {
		throw new Exception("Invalid path.");
	    }
	}  catch(Throwable e) {
	    PrintWriter out = res.getWriter();
	    out.println("<HEAD><TITLE>Exception processing ViewWeed</TITLE></HEAD>");
	    out.println("<BODY><PRE>");
	    e.printStackTrace(out);
	    out.println("</PRE></BODY>");
	} 
    }
    
    public void serveImage(HttpServletResponse res,String type,String name) throws Exception{
	Weeds w=new Weeds();
	int index=name.indexOf(".gif");
	if (index==-1)
	    throw new Exception("bad filename <"+index+">");
	
	String f=name.substring(0,index);
	String g=w.getOldId(f);
	
	ResultSet rs=w.selectFromImages(g,type);
	String mimeType=rs.getString(1);
	byte[] img=rs.getBytes(2);
	
	res.setContentType(mimeType);
	OutputStream os=res.getOutputStream();
	os.write(img);
	os.close();
    };

    public String getServletInfo() {
	return "ViewWeed";
    }
    
}













