package tapir.weeds;

import tapir.weeds.representation.*;
import honeylocust.msxml.parser.ParseException;

import java.io.*;
import java.sql.*;

public class WeedBean extends GeneralBean {

  DBSpecies d_species;
  int d_width,d_height;

  public WeedBean(String id) throws ClassNotFoundException,SQLException {
    super();
    d_species=new DBSpecies(d_weeds,id);
    ResultSet rs=d_weeds.selectSizeFromImages(d_species.getOldId(),"small");
    d_width=rs.getInt(1);
    d_height=rs.getInt(2);
  };

  public LanguageString getPrincipalLatin() throws SQLException {
    return d_species.getLatin()[0];
  };

  public String getTitle() throws SQLException {
    return d_species.getId()+": "+getPrincipalLatin();
  };

  public String getKeywords() throws SQLException {
    StringBuffer sb=new StringBuffer(super.getKeywords());
    LanguageString family=d_species.getFamily();
    if (family!=null) {
      sb.append(',');
      sb.append(family.toString());
    };

    LanguageString latin[]=d_species.getLatin();
    for(int i=0;i<latin.length;i++) {
      sb.append(',');
      sb.append(latin[i].toString());
    };
    
    LanguageString common[]=d_species.getCommon();
    for(int i=0;i<common.length;i++) {
      sb.append(',');
      sb.append(common[i].toString());
    };
    
    return sb.toString();
  };

  public String getSmallImageURL() {
    return "../small/"+d_species.getId()+".gif";
  };

  public String getBigImageURL() {
    return "../big/"+d_species.getId()+".gif";
  };

  public int getSmallImageHeight() {
    return d_height;
  };

  public int getSmallImageWidth() {
    return d_width;
  };

  public LanguageString getFamily() throws SQLException {
    return d_species.getFamily();
  };

  public LanguageString[] getCommon() throws SQLException {
    return d_species.getCommon();
  };

  public Text[] getTexts() throws SQLException,ParseException {
    return d_species.getTexts();
  };

  public String toHtml(Text[] t) throws SQLException {
    StringBuffer out=new StringBuffer();
    for(int i=0;i<t.length;i++) {
      out.append(toHtml(t[i]));
    };

    return out.toString();
  };


  public String toHtml(Text t) throws SQLException {
    StringBuffer out=new StringBuffer();
    out.append("<P>");
    TextChunk[] chunks=t.getChunks();
    for(int i=0;i<chunks.length;i++) {
      generateChunk(out,chunks[i]);
    };

    return out.toString();
  };

  void generateChunk(StringBuffer out,TextChunk c) throws SQLException {
    if (c instanceof AnchorChunk) {
      generateAnchorChunk(out,(AnchorChunk) c);
    } else if (c instanceof RefChunk) {
      generateRefChunk(out,(RefChunk) c);
    } else
      out.append(c.getText());
  };

  void generateAnchorChunk(StringBuffer out,AnchorChunk ac) {
    out.append("<A HREF=\""+ac.getHref()+"\">"+ac.getText()+"</A>");
  };

  void generateRefChunk(StringBuffer out,RefChunk ac) throws SQLException {
    DBSpecies target=new DBSpecies(d_weeds,ac.getId());
    if (target==null)
      throw new RuntimeException("Invalid ref id.");

    out.append("<A HREF=\"../"+ac.getId()+"/index.html\">"+d_weeds.speciesName(target)+"</A>");
  };

  public String getNumberNav() {
    int id=Integer.parseInt(d_species.getId());
    return getNumberNav(id);
  };


};







