package tapir.weeds.representation;

import java.util.Hashtable;

public class LanguageString {

  private final String d_string;
  private final String d_language;

  private static String s_defaultLanguage="en".intern();
  private static final Hashtable s_symbols=new Hashtable(); // used for intern() facility

  public LanguageString(String s) {
     d_string=s;
     d_language=s_defaultLanguage;
  };

  public LanguageString(String s,String lang) {
     d_string=s;
     if (lang==null)
       lang=s_defaultLanguage;

     d_language=lang.intern();
  };

  public String toString() {
     return d_string;
  };

  public String getLanguage() {
    return d_language;
  };

// this does the same thing for LanguageString that String.intern()
// does for String.

  public LanguageString intern() {
    String uniqname=d_string+"&"+d_language;
    synchronized(s_symbols) {
      LanguageString interned=(LanguageString) s_symbols.get(uniqname);
      if(interned==null) {
        interned=this;
	s_symbols.put(uniqname,this);
      }
      return interned;     
    }
  }

};

