package tapir.weeds.representation;

class TextImpl implements Text {

  TextChunk[] d_chunks;

  String d_type;
  String d_source;
  String d_language;

  public TextImpl() {
  };

  public TextImpl(Text t) {
    d_type=t.getText();
    d_source=t.getSource();
    d_language=t.getLanguage();
    d_chunks=t.getChunks();
  };

  public String getType() {
    return d_type;
  }

  public TextChunk[] getChunks() {
    return ((TextChunk[]) d_chunks.clone());
  }

  public String getSource() {
    return d_source;
  }

  public String getLanguage() {
    if (d_language==null)
      return "en".intern();

    return d_language;
  }

  public String getText() {
    StringBuffer sb=new StringBuffer();

    for(int i=0;i<d_chunks.length;i++)
      sb.append(d_chunks[i].getText());

    return sb.toString();
  };

};
