package com.wrox.util;

/**
 * This class includes a static method for replacing a substring 
 * with another substring in a String. Even though this is a very 
 * common operation neither the String nor StringBuffer class 
 * provides such a method.
 *
 * You can use the StringUtils class in your application like this:
 * import com.wrox.pssjp.util.StringUtils;
 *
 *   public class MyApp {
 *
 *	   public void myMethod() {
 *		 String hello = "Hello World!";
 *		 hello = StringUtils.replaceInString(hello, "World", "Java");
 *	   }
 *   }
 *
 * @author Hans Bergsten, Gefion software (www.gefionsoftware.com)
 */
public class StringUtils {

    /**
     * Returns a String with all occurrences of the String from 
     * replaced by the String to.
     *
     * @return The new String
     */
    public static String replaceInString(String in, String from, String to) {
        StringBuffer sb = new StringBuffer(in.length() * 2);
        String posString = in.toLowerCase();
        String cmpString = from.toLowerCase();
        int i = 0;
        boolean done = false;
        while (i < in.length() && !done) {
            int start = posString.indexOf(cmpString, i);
            if (start == -1) {
                done = true;
            }
            else {
                sb.append(in.substring(i, start) + to);
                i = start + from.length();
            }
        }
        if (i < in.length()) {
            sb.append(in.substring(i));
        }
        return sb.toString();    
   }
}