import javax.servlet.*;
import javax.servlet.http.*;

import java.io.*;
import java.util.*;
import java.net.URLEncoder;

import com.wrox.context.chat.*;

public class ListRoomsServlet extends HttpServlet
{

   public void doGet(HttpServletRequest req, HttpServletResponse res) 
               throws IOException
   {

      res.setContentType("text/html");
      PrintWriter out = res.getWriter();
  
      String expand = req.getParameter("expand");
      HttpSession session = req.getSession();
      String avatarName = (String) session.getValue("avatarName");
      if (avatarName == null)
      {
         avatarName = "";
      }

      writePage(out, expand, avatarName);
      out.close();
   }

   private void writePage(PrintWriter out, String expand, String avatarName)
   {
            
      out.println("<HTML>");
      out.println("<HEAD><TITLE>Chat rooms</TITLE></HEAD>");
      out.println("<BODY>");
      out.println("<H1>Chat rooms</H1>");
      out.println("<FORM METHOD=POST ACTION=chatRoom>");
        
      // Add radio boxes for selecting a room
      out.println("Select the room you like to enter " +
         "or click on a name to see the description:<P>");
      RoomList roomList = (RoomList) getServletContext().getAttribute("roomList");
      Enumeration rooms = roomList.getRooms();
      boolean isFirst = true;
      while (rooms.hasMoreElements())
      {
         ChatRoom room = (ChatRoom) rooms.nextElement();
         String roomName = room.getName();
         out.println("<INPUT TYPE=RADIO NAME=roomName VALUE='" +
            roomName + "'" +
            (isFirst ? " CHECKED" : "") + ">" + 
            "<A HREF=listRooms?expand=" + 
            URLEncoder.encode(roomName) + ">" + 
            roomName + "</A><BR>");
         isFirst = false;
           
         // Show description if requested
         if (expand != null && expand.equals(roomName))
         {
            out.println("<BLOCKQUOTE>");
            out.println(room.getDescription());
            out.println("</BLOCKQUOTE><BR>");
         }
      }
        
      // Add a field for the avatar name
      out.println("<P>Enter your name: ");
      out.println("<INPUT NAME=avatarName VALUE='" +
         avatarName + "' SIZE=30>");
        
      // Add submit button
      out.println("<P><INPUT TYPE=SUBMIT VALUE='Enter'>");
      out.println("</FORM>");
      out.println("</BODY></HTML>");
   }
}