package ap.servlets;

import java.sql.*;

public class html {

  public static final int NORMAL = 0;
  public static final int HEADING = 1;
  public static final int LINE = 2;

  public StringBuffer buffer;

  public html(String _title) {
    buffer =  new StringBuffer(4096);
    this.buffer.append("<html><head><title>");
    this.buffer.append(_title);
    this.buffer.append("</title></head>");
    this.buffer.append("<body>");
  }

  public void add(int _style, String _text, boolean _break) {
    switch(_style) {
      case NORMAL:
        this.buffer.append(_text);
        break;
      case HEADING:
        this.buffer.append("<h1>");
        this.buffer.append(_text);
        this.buffer.append("</h1>");
        break;
      case LINE:
        this.buffer.append("<hr>");
        break;
      default:
        break;
    }
    if(_break) {
      this.buffer.append("<br>");
    }
  }

  public boolean addTable(String _labels[], ResultSet _rs){

    int cols = _labels.length;

    this.buffer.append("<table width='100%'>");
    this.buffer.append("<tr>");
    for (int i = 0; i < cols; i++) {
      this.buffer.append("<th align='left'>");
      this.buffer.append(_labels[i]);
      this.buffer.append("</th>");
    }
    this.buffer.append("</tr>");

    try {
      while (_rs.next()) {
        this.buffer.append("<tr>");
        for (int i = 1; i <= cols; i++) {
          this.buffer.append("<td>");
          this.buffer.append(_rs.getString(i));
          this.buffer.append("</td>");
        }
        this.buffer.append("</tr>");
      }
    }
    catch (SQLException e) {
      return false;
    }

    this.buffer.append("</table>");
    return true;

  }

  public String getPage() {
    return this.buffer.toString() + "</body></html>";
  }

}
