//Source file: c:/work/wrox/case_study/code/BugTrackerApp/apputil/AppConfig.java

package apputil;
import java.io.*;
import java.util.*;

/**
The AppConfig class provides a single point of obtaining application configuration
information. The data is stored in a Properties file, whose name is specified in the 
constructor. The data is stored in a class member, so once it has been instantiated for
the application, it can be accessed by other methods without having to know the location
of the configuration properties file.
*/
public class AppConfig implements apputil.Testable
{
	
	static protected Properties applicationProperties;
	public static final String JDBCDRIVER = "jdbcdriver";
	public static final String JDBCURL	  = "jdbcurl";
	public static final String JDBCUSER 	= "jdbcuser";
	public static final String JDBCPASS 	=	"jdbcpass";
	public static final String SERVICENAME		=	"servicename";
	public static final String SMTPHOST		= "smtphost";
	public static final String AGENTEMAIL = "agentemailaddress";

		
	/**
	Constructor, populuates the application properties
	from the configuration file identified
	in the parameter.
	@param configilename specifies the file that contains the application properties	
	*/
	public AppConfig(String configfilename) throws java.io.IOException
	{
		FileInputStream fis = new FileInputStream(configfilename);
		applicationProperties = new Properties();
		applicationProperties.load(fis);
	}
	
	/** 
	Get the email address for the bug tracker agent. This is the email address
	from which automated defect reports will be sent, and the recipients of 
	these updates will see as the "from" address on the email.
	@return returns a string containing the agent email address	
	*/
	public String getBugTrackerAgentEmail()
	{
		return applicationProperties.getProperty(AGENTEMAIL);
			
		};	
		
	
	/**
		 Get the name of the JDBC database driver for the application.
		 Returns an empty string if the driver hasn't been set in the
		 configuration file.
	   @return returns a string containing the driver name

	 */
	public String getDatasourceDriver() 
	{
			return applicationProperties.getProperty(JDBCDRIVER);
			
		}
		
	/**
		 Get the name of the datasource for the application. 
		 Returns an empty string if the driver hasn't been set
		 int the configuration file.
	 */
	public String getDatasourceURL() 
	{
			return applicationProperties.getProperty(JDBCURL);

		}
		
		
	/**
		Get the username for the data source
		*/
	public String getDatasourceUser()
	{
			return applicationProperties.getProperty(JDBCUSER);
		
	}	
	
	/**
		Get the username's for the data source
		*/
	public String getDatasourcePass()
	{
			return applicationProperties.getProperty(JDBCPASS);
		
	}	
	
		
	/**
	Gets the registration name for the DefectServer orb service
	as it is/will be registered with the ORB Naming Service.
		*/
	public String getBugServerServiceName()
	{
			return applicationProperties.getProperty(SERVICENAME);
			
	}
	
	/**
	Gets the host name of the SMTP server
	
	*/
	public String getSMTPHost()
	{
			return applicationProperties.getProperty(SMTPHOST);
			
	}
	
	
	/**
	Supports test harness for unit testing
	@return returns true for success, false for failure.

	*/		
		
	public boolean TestUnit()
	{
		
			boolean results = false;
		  
			String driver = this.getDatasourceDriver();
			String source = this.getDatasourceURL();
			String host = this.getSMTPHost();
			String orbname = this.getBugServerServiceName();
				
			if (driver.length() > 0)	
				if (source.length() > 0)
					if (host.length() > 0)
						if (orbname.length() > 0)
							results = true;
		  
		  return results;
		
	}

	/**
	default constructor provided for test harness
	*/
	public AppConfig()
	{
	
	 }
			
		
}