//Source file: c:/work/wrox/case_study/code/BugTrackerApp/businesslogic/DefectFactory.java

package businesslogic;

import dataabstraction.PersistentDefect;

import java.sql.SQLException;

/**
Implementation of the _DefectFactoryIntfOperations interface, which is used by the
tie class generated by idltojava.
The DefectFactory, as the name implies, provides a single distributed object
through which client applications can access existing and create new defect objects
*/
public class DefectFactory implements _DefectFactoryIntfOperations 
{
	public DefectPolicy m_DefectPolicy;
	
	/** constructor accepts a single argument that
	identifies the defect policy object
	@param thePolicy the defect policy object
	*/
	public DefectFactory(DefectPolicy thePolicy) 
	{
		m_DefectPolicy = thePolicy;
		
		}
	
	/**
	 This method provides a means of creating new defects.
	 @param userid identifies the id of the user; this is used by the policy object
	 @return returns the newly created Defect object
	 */
	public businessmodel.DefectIntf NewDefect(String userid) 
	{
		return m_DefectPolicy.createNewDefect(userid);	
		}
	
	/**
	Attempt to reconstitute a stored defect.
	@param defectid unique id for the defect
	@exception NotFoundException thrown if the defect with the specified ID doesn't exist
	*/	
	public businessmodel.DefectIntf getDefect(int defectid) throws NotFoundException
	{
		
		try
		{
			businessmodel._DefectIntfTie base;
			
			// need to get assign a new uid to the defect
			PersistentDefect theDefect = 	new PersistentDefect();
			theDefect.setDefectID(defectid);
			theDefect.fetch();
			theDefect.setPolicy(m_DefectPolicy);
			
			/* create the tie object, bind it to the defect,
				 and let the policy object bind it to the orb */	
			
			base = new businessmodel._DefectIntfTie(theDefect);
			m_DefectPolicy.implConnect(base);
	
			return base;
		
		}		
		catch(SQLException sqle)
		{
			throw new NotFoundException();
		}
	}
	
	
	
}