//Source file: c:/work/wrox/case_study/code/BugTrackerApp/businesslogic/DefectServer.java

//import application packages
package businesslogic;

//import system packages
import org.omg.CosNaming.*;
import org.omg.CosNaming.NamingContextPackage.*;
import org.omg.CORBA.*; 

/**
DefectServer is the primary entry point for the BugTracker's server-side
components. It implements the _DefectServerIntfOperations interface, which
is used by the tie class generated by idltojava.

The main method of this class provides the entry point for the ORB server of this application.
*/

public class DefectServer implements _DefectServerIntfOperations 
{
	public DefectFactoryIntf m_DefectFactory;
	public DefectPolicyIntf m_DefectPolicy;
	public UserFactoryIntf m_UserFactory;
	
	public DefectServer(DefectFactoryIntf theDefectFactory, DefectPolicyIntf thePolicy, UserFactoryIntf theUserFactory) 
	{
		m_DefectFactory = theDefectFactory;
		m_DefectPolicy = thePolicy;
		m_UserFactory = theUserFactory;
		}
	
	/**
	 accessor method
	 	 */
	public businesslogic.DefectFactoryIntf getDefectFactory() 
	{
			return m_DefectFactory;
			
	 }
	
	/**
	   accessor method
	 */
	public businesslogic.DefectPolicyIntf getPolicyObject() 
	{
		return m_DefectPolicy;
		
	}
	
	/**
		accessor method
	*/	
	public businesslogic.UserFactoryIntf getUserFactory()
	{
		return m_UserFactory;
	}
	
	/**
	This is the entry point for the defect server. It's responsible for
	initializing the Orb and the server-side objects for creating defects
	and the policy object(s) that administer them.
	
	It also registers the defect server with the naming service
	
	*/
	
	public static void main(String[] args)
	{
			apputil.AppConfig config;
			
			System.out.println("java businesslogic.DefectServer {<configfile> <orb opt 1> .... <orb opt n>}");
			
	   	try
	   	{
	   			if (args.length == 0)
	   					config = new apputil.AppConfig("BUGTRACKER.PROPS");
					else
							config = new apputil.AppConfig(args[0]);	   					
	   			
	    		// create and initialize the ORB	    
	    		ORB orb = ORB.init(args, null); 
	    		
	    		// create the policy object
	    		DefectPolicy policyImpl = new DefectPolicy();
	    		policyImpl.setOrb(orb);
	    		
	    		_DefectPolicyIntfTie policyObj = new
	    			_DefectPolicyIntfTie(policyImpl);
	    		orb.connect(policyObj);
	    		
	    		System.out.println("Created policy object as " + orb.object_to_string(policyObj));
	    		
	    		// create the defect factory object
	    		DefectFactory defectfactoryImpl = new DefectFactory(policyImpl);
	    		_DefectFactoryIntfTie defectfactoryObj = new
	    			_DefectFactoryIntfTie(defectfactoryImpl);
	    		orb.connect(defectfactoryObj);
	    		
					System.out.println("Created defect factory object as " + orb.object_to_string(defectfactoryObj));	    		
					
					// create the user factory object
					UserFactory userfactoryImpl = new UserFactory(policyImpl);
					_UserFactoryIntfTie userfactoryObj = new
						_UserFactoryIntfTie(userfactoryImpl);
					orb.connect(userfactoryObj);
					
					System.out.println("Created user factory object as " + orb.object_to_string(userfactoryObj));	    		

	    			    		
	    		// create the server object; pass it factory and policy
	    		DefectServer serverImpl = new DefectServer(defectfactoryObj, policyObj, userfactoryObj);
	    		_DefectServerIntfTie serverObj = new
	    			_DefectServerIntfTie(serverImpl);
	    		orb.connect(serverObj);
	    		
	    		System.out.println("Created server object as " + orb.object_to_string(serverObj));
	    		
	    		System.out.println("Registering servers with naming service...");
	    				
	    		// get the root naming context	    
	    		org.omg.CORBA.Object objRef = 
								orb.resolve_initial_references("NameService");
														
	    		NamingContext ncRef = NamingContextHelper.narrow(objRef); 
	    
	    		// bind the Object Reference in Naming
	    		
	    		NameComponent nc = 
	    			new NameComponent(config.getBugServerServiceName(), "");
	    		NameComponent path[] = {nc};
	    		ncRef.rebind(path, serverObj); 
	    		
	    		System.out.println("Ready.");
	    		
	    		// wait for invocations from clients
          java.lang.Object sync = new java.lang.Object();
          synchronized (sync) 
          {                
          	sync.wait();            
          } 
          
			} 
			catch (Exception e) 
			{			    
				System.err.println("ERROR: " + e);
	    	e.printStackTrace(System.out);	
	    }    
		
		
		
	}
	
	
}