//Source file: c:/work/wrox/case_study/code/BugTrackerApp/businessmodel/User.java

package businessmodel;

import apputil.*;

/**
This class implements the _UserIntfOperations interface, used by the tie class
generated by idltojava. 
*/
public class User implements  _UserIntfOperations, apputil.Testable 
{
	protected int m_privLevel;
	protected String m_userID;
	protected String m_lastName;
	protected String m_firstName;
	protected String m_phoneNumber;
	protected String m_faxNumber;
	protected String m_emailAddress;
	
	/**
		default constructor
	*/
	public User()
	{
		m_privLevel = 0;
		m_userID = "";
		m_lastName = "";
		m_firstName = "";
		m_phoneNumber = "";
		m_faxNumber = "";
		m_emailAddress = "";
		};
		
	/**
	   Accessor method
	   	 */
	public String getUserID() {
    		return this.m_userID;
    }
	
	/**
	   Accessor method
	 */
	public String getLastName() {
    		return this.m_lastName;
    }
	
	/**
	   Accessor method
	 */
	public String getFirstName() {
    		return this.m_firstName;
    }
	
	/**
	   Accessor method
	 */
	public String getPhone() {
    		return this.m_phoneNumber;
    }
	
	/**
	   Accessor method
	   */
	public String getFax() {
    		return this.m_faxNumber;
    }
	
	/**
	   Accessor method
	 */
	public String getEmail() {
    		return this.m_emailAddress;
    }
	
	/**
	   Accessor method
	 */
	public int getPriv() {
    		return this.m_privLevel;
    }
	
	/**
	   Accessor method
	 */
	public void setLastName(String name) {
    		this.m_lastName = name.trim();
    }
	
	/**
	   Accessor method
	 */
	public void setUserID(String id) {
    		this.m_userID = id.trim();
    }
	
	/**
	   Accessor method
	 */
	public void setFirstName(String name) {
    		this.m_firstName = name.trim();
    }
	
	/**
	   Accessor method
	 */
	public void setPhone(String phone) {
    		this.m_phoneNumber = phone.trim();
    }
	
	/**
	   Accessor method
	 */
	public void setFax(String fax) {
    		this.m_faxNumber = fax.trim();
    }
	
	/**
	   Accessor method
	 */
	public void setEmail(String email) {
    		this.m_emailAddress = email.trim();
    }
	
	/**
	   Accessor method
	 */
	public void setPriv(int priv) 
		{
    		this.m_privLevel = priv;
    		
    }

 /**
  Applies all changes made  to the User
  @param userid id of user applying commit
  @exception UpdateException thrown if the defect cannot be changed
  @exception AppSecurityException thrown if the user does not have sufficient privileges
  */  
  public void commit(String userid) throws UpdateException, AppSecurityException
	{
		;
	}

  /**
  This method returns the internal state of the object. It is primarily 
  used for debugging.
  @return returns string representation of internal state of object
  */  
  public String toString()
	{
		String retval = new String("User {" +
		
		"UserID = " +  m_userID +
		", LastName = " + m_lastName +
		", FirstName = " + m_firstName +
		", nphonenumber = " + m_phoneNumber +
		", faxnumber = " + m_faxNumber +
		", email = " + m_emailAddress +
		", PrivLevel = " + m_privLevel);
		
		return retval;
	}
	
	
	/**
	TestUnit method implemented to support the apputil.Testable interface.
	This enables the class to be tested by the test harness.
	*/
	public boolean TestUnit()
	{
		boolean retval;
		retval = false;
		
		String lname = "Fife";
		String fname = "Barney";
		String uid = "bfife";
		String fax = "";
		String phone = "200.200.2000";
		String email = "barney@mayberry.city.gov";
		int priv = 	DefectPrivileges.CANCREATE +
								DefectPrivileges.CANCHANGEASSIGN +
								DefectPrivileges.CANRESOLVE;
								
		this.setUserID(uid);
		this.setLastName(lname);
		this.setFirstName(fname);
		this.setPhone(phone);
		this.setFax(fax);
		this.setEmail(email);
		this.setPriv(priv);
		
		if (uid.equals(this.getUserID()))
			if (lname.equals(this.getLastName()))
				if (fname.equals(this.getFirstName()))
					if (phone.equals(this.getPhone()))
						if (fax.equals(this.getFax()))
							if (priv == this.getPriv())
								retval = true;
		
		return retval;	
		
	}
	
}