
/*
		file	:	NotificationForm.java

*/



package ui;
import businessmodel.DefectIntf;

import javax.swing.*;
/**
Tab panel for the BugTracker application. This class implements the
DefectModelListener interface, and coordinates updates to the model 
via this interface. 

Note that model updates are "on demand" from the model - the panels do not 
actively update the model until an update is requested by the model.

*/

public class NotificationForm extends JPanel implements DefectModelListener
{
	
	JLabel label_changedmaillist;
	JLabel label_resolvedmaillist;
	JTextField text_changedmaillist;
	JTextField text_resolvedmaillist;
	
	public NotificationForm()
	{

		super();
		
		int nPos;

		setLayout(null);
		setVisible(false);
		setSize(612,439);
		
		label_changedmaillist = new JLabel();
		label_changedmaillist.setText("Notify via email when changed:");
		label_changedmaillist.setBounds(12,12,204,26);
		add(label_changedmaillist);
		
		label_resolvedmaillist = new JLabel();
		label_resolvedmaillist.setText("Notify via email when resolved:");
		label_resolvedmaillist.setBounds(12,72,187,23);
		add(label_resolvedmaillist);
		
		text_changedmaillist = new JTextField();
		text_changedmaillist.setBounds(12,36,410,22);
		add(text_changedmaillist);
		
		text_resolvedmaillist = new JTextField();
		text_resolvedmaillist.setBounds(12,96,410,22);
		add(text_resolvedmaillist);		
		
	}
	
		/**
	The listener is called via this method when the underlying model has
	been changed. The lister is then responsible for updating the information
	displayed in the UI based on the state of the model.
	*/
	public void ModelUpdated(DefectIntf defect)
	{
		// update display of changed notification list
		text_changedmaillist.setText(defect.getChangedMailList());
		
		// update display of resolved notification list
		text_resolvedmaillist.setText(defect.getResolvedMailList());
		
	}
	
	
	/**
	The listener is called via this method when the underlying model requests
	that it be updated by the information in the UI. Any information that
	the listener has changed and wants the model to reflect will be 
	changed by the listener
	*/
	public void UpdateModel(DefectIntf defect)
	{
		if (isDirty(defect))
		{
		
		// update display of changed notification list
		defect.setChangedMailList(text_changedmaillist.getText());
		
		// update display of resolved notification list
		defect.setResolvedMailList(text_resolvedmaillist.getText());
						
		};
		
	}
	
	/** 
	the listener is called via this method when the model needs to determine
	if the listener needs to update the model.
	*/
		
	public boolean isDirty(DefectIntf defect)
	{
		
		boolean retval;
		retval = true;
		if (text_changedmaillist.getText().trim().equals(defect.getChangedMailList().trim()))
			if (text_resolvedmaillist.getText().trim().equals(defect.getResolvedMailList().trim()))
				retval = false;
		
		return retval;
	}
		

}