sun.jdbc.odbc.JdbcOdbcDriver
jdbc:odbc:bug_tracker_sqla
guest
guest

DROP TABLE users
DROP TABLE defects
DROP TABLE defect_priority
DROP TABLE defect_severity
DROP TABLE defect_state
DROP TABLE privilege_defs

create table users (userid char(8), lastname char(20), firstname char(20), phonenumber char(20), faxnumber char(20), emailaddress char(50), priv_levels int)
create table defects (defectid int, product char(30), versionreported char(8), subsystem char(20), defectsummary char(50), defectdetail varchar(250), state int, priority int, severity int, reportedby char(15), assignedto char(8), datereported date, datelastchanged date, resolutionnotes varchar(50), changedmodules varchar(50), changedmaillist varchar(50), resolvedmaillist varchar(50), versionresolved char(8), externalid varchar(25))
create table defect_priority (priority int, pri_name char(15))
create table defect_severity (severity int, sev_name char(15))
create table defect_state (state int, state_name char(15))
create table privilege_defs ( priv int, priv_name char(25))
	
#populate the users table
insert into users (userid, lastname, firstname, phonenumber, faxnumber, emailaddress, priv_levels) values ('rkp','Phillips','Ron','555.555.3416','555.555.3415','rkp@happykitty', 31)
insert into users (userid, lastname, firstname, emailaddress, priv_levels) values ('www','Web agent','Web agent', 'webagent@happykitty.com', 0)

#populate the defects table
insert into defects (defectid, product, versionreported, subsystem, defectsummary, defectdetail, state, priority, severity, reportedby, assignedto, datereported, datelastchanged, changedmaillist, resolvedmaillist) values (1, 'bug tracker', '1.0', 'file.new', 'cannot create a new defect', 'creating a new defect causes class not found exception', 1, 1, 1, 'rkp', 'rkp', 'April 1 1999', 'April 1 1999', 'rkp@acm.org', 'joejoe@xxx.com')

#populate the defect_priority table
insert into defect_priority (priority, pri_name) values (1, 'CRITICAL')
insert into defect_priority (priority, pri_name) values (2, 'HIGH')
insert into defect_priority (priority, pri_name) values (3, 'NORMAL')

#populate the defect_severity table
insert into defect_severity (severity, sev_name) values (1, 'CRASH')
insert into defect_severity (severity, sev_name) values (2, 'DATACORRUPTION')
insert into defect_severity (severity, sev_name) values (3, 'MISBEHAVIOR')
insert into defect_severity (severity, sev_name) values (4, 'COSMETIC')

#populate the defect_state table
insert into defect_state (state, state_name) values (1, 'NEW')
insert into defect_state (state, state_name) values (2, 'ASSIGNED')
insert into defect_state (state, state_name) values (3, 'FIXED')
insert into defect_state (state, state_name) values (4, 'FIX_VERIFIED')
insert into defect_state (state, state_name) values (5, 'DUPLICATE')
insert into defect_state (state, state_name) values (6, 'NOTREP')

#populate the privilege_defs table
insert into privilege_defs (priv, priv_name) values (0, 'Create defect')
insert into privilege_defs (priv, priv_name) values (1, 'Alter defect assignment')	
insert into privilege_defs (priv, priv_name) values (2, 'Alter defect priority')	
insert into privilege_defs (priv, priv_name) values (4, 'Verify defect as fixed')
insert into privilege_defs (priv, priv_name) values (8, 'Resolve defect')
insert into privilege_defs (priv, priv_name) values (16, 'Administer')
