package com.wrox.WroxJiniServices;

import java.rmi.*;
import java.net.*;
import java.util.*;
import java.rmi.server.*;
import com.sun.jini.lookup.*;
import com.sun.jini.lease.*;
import net.jini.core.entry.*;
import net.jini.core.lookup.*;
import net.jini.lookup.entry.*;
import net.jini.discovery.*;

public class GenericServices {
    static GenericServices myInstance;

    public static void main(String args[]) throws Exception {

        Vector servicesToRegister = new Vector(3);
        myInstance = new GenericServices();

        if (System.getSecurityManager() == null)
                System.setSecurityManager(new RMISecurityManager());
        servicesToRegister.add(new LocalProxyJiniServiceImpl());
        servicesToRegister.add(new ProxyRemoteJiniServiceImpl(new RMIBasedJiniServiceImpl()));
        servicesToRegister.add(new RMIBasedJiniServiceImpl());

        System.out.println("Registering servers with lookup service...");

        try {
            Iterator it = servicesToRegister.iterator();

            while (it.hasNext()) {
                IWroxJiniService me = (IWroxJiniService) it.next();
                new JoinManager(
                            me,
                            me.getEntries(),
                            new NotifyCatcher(),
                            null
                            );
            System.out.println("Registered a service");
            }

            synchronized (servicesToRegister) {
                servicesToRegister.wait(0);
            }

        } catch (Exception e) {
            System.out.println("Caught exception " +e);
        }
    }
}

class NotifyCatcher implements ServiceIDListener {
    public void serviceIDNotify (ServiceID id) {
        System.out.println("Registered with Service ID: " + id);
    }
}