package com.wrox.WroxJiniServices;

import net.jini.core.entry.*;
import net.jini.lookup.entry.*;
import java.net.*;

public class LocalProxyJiniServiceImpl implements IWroxJiniService {

    static final String SERVICE_NAME = "Jini Service - Local Proxy";
    static final String SERVICE_MFR = "Sing Li";
    static final String SERVICE_VENDOR = "Wrox";
    static final String SERVICE_VERSION = "1.0";
    static final String SERVICE_COMMENT = "This is a local proxy implementation.";
    static final String LOCATION_FLOOR = "first";
    static final String LOCATION_ROOM = "computer";
    static final String LOCATION_BUILDING = "8C";
    static final String CLASS_NAME = "wroxCallable";

    public LocalProxyJiniServiceImpl() {
    }

    public String grabData() {
        try {
            return "Executed on " + InetAddress.getLocalHost()
                    + ". Data Returned locally from within the client.";
        } catch (java.net.UnknownHostException e) {
            return "Data returned locally from within the client.";
        }
    }

    public Entry[] getEntries() {
        Entry myEntry[] = new Entry[4];
        myEntry[0] = new ServiceInfo(
                SERVICE_NAME,
                SERVICE_MFR,
                SERVICE_VENDOR,
                SERVICE_VERSION,
                "",                              //   Model goes here
                ""                               //   Serial Number goes here
                );
        myEntry[1] = new Name(
                CLASS_NAME
                );
        myEntry[2] = new Comment(
                SERVICE_COMMENT
                );
        myEntry[3] = new Location(
                LOCATION_FLOOR,
                LOCATION_ROOM,
                LOCATION_BUILDING
                );
        return myEntry;
    }
}