package com.wrox.WroxJiniServices;

import java.rmi.*;
import java.net.*;
import java.rmi.server.*;
import net.jini.lookup.entry.*;
import com.sun.jini.lookup.*;
import com.sun.jini.lease.*;
import net.jini.core.entry.*;
import net.jini.core.lookup.*;
import net.jini.discovery.*;

public class RMIBasedJiniServiceImpl extends UnicastRemoteObject
        implements IRMIBasedJiniService,IWroxJiniService {

    static final String SERVICE_NAME = "Jini Service - RMI";
    static final String SERVICE_MFR = "Sing Li";
    static final String SERVICE_VENDOR = "Wrox";
    static final String SERVICE_VERSION = "1.0";
    static final String SERVICE_COMMENT = "This is an RMI implementation.";
    static final String LOCATION_FLOOR = "second";
    static final String LOCATION_ROOM = "computer";
    static final String LOCATION_BUILDING = "8C";
    static final String CLASS_NAME = "wroxCallable";

    public RMIBasedJiniServiceImpl() throws RemoteException {

    }

    public String grabData() {
        try {
            return "Executed on " + InetAddress.getLocalHost()
                    + ". Data Returned remotely via RMI from server.";
        } catch (java.net.UnknownHostException e) {
            return "Data transmitted remotely via RMI from server.";
        }
    }
    
    public Entry[] getEntries() {
        Entry myEntry[] = new Entry[5];
        myEntry[0] = new ServiceInfo(
                SERVICE_NAME,
                SERVICE_MFR,
                SERVICE_VENDOR,
                SERVICE_VERSION,
                "",                              //   Model goes here
                ""                               //   Serial Number goes here
                );
        myEntry[1] = new Name(
                CLASS_NAME
                );
        myEntry[2] = new Comment(
                SERVICE_COMMENT
                );
        myEntry[3] = new Location(
                LOCATION_FLOOR,
                LOCATION_ROOM,
                LOCATION_BUILDING
                );
        myEntry[4] = new WroxServiceAttributes(
                "Professional Java Server Programming"
                );
        return myEntry;
    }
}