package com.wrox.javaSpaces;

import com.sun.jini.mahout.binder.RefHolder;
import net.jini.core.lease.*;
import net.jini.space.JavaSpace;
import net.jini.core.transaction.Transaction;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.util.*;
import net.jini.core.entry.*;

public class CreditCheckerNode extends ServerNode
{

   static final String IN_SPACE = "CreditSpace";
   static final String OUT_SPACE = "ConfirmedSpace";
   static final double CHANCE_OF_NO_CREDIT = 0.2;
   static final double AVERAGE_CREDIT = 10000.0;
   private JavaSpace inSpace;
   private JavaSpace outSpace;
   private Random myRand = new Random();

   public CreditCheckerNode()
   {
      super();
   }

   public void Initialize()
   {
      if (System.getSecurityManager() == null)
      {  System.setSecurityManager(new RMISecurityManager()); }

      System.out.println("Credit Checker server running...");
      inSpace = locateSpace(IN_SPACE);
      outSpace = locateSpace(OUT_SPACE);
   }

   public void doWork()
   {
      while (true)
      {
         try
         {
            UserEntry workEntry = (UserEntry) inSpace.take(
                          new UserEntry(null,null,null,null,null,null), // Template
                          null,                                         // Transaction
                          Lease.FOREVER                                 // Time to wait
                          );
            System.out.println("Took an entry for Name: " + workEntry.userName + "...");
            workEntry.creditLimit = determineCredit(workEntry.userName, workEntry.memberID);
            System.out.println("Checked for credit... credit granted is $" +
                      workEntry.creditLimit);

            outSpace.write(workEntry, null, Lease.FOREVER);
         }
         catch (Exception err)
         {
            System.out.println(err.getMessage());
            err.printStackTrace();
         }
      }
   }

   Double determineCredit(String userName, String memberID)
   {
      if (myRand.nextDouble() < CHANCE_OF_NO_CREDIT)
      {  return new Double(0.0); }
      else
      {  return new Double((AVERAGE_CREDIT / 2.0) + (myRand.nextDouble() * AVERAGE_CREDIT)); }
   }

   public static void main(String[] args)
   {
      CreditCheckerNode myNode = new CreditCheckerNode();
      myNode.Initialize();
      myNode.doWork(); // forever
      System.exit(0);
   }
}