package com.wrox.javaSpaces;

import net.jini.core.lease.*;
import net.jini.space.JavaSpace;
import net.jini.core.transaction.Transaction;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;

import net.jini.discovery.*;
import net.jini.core.lookup.*;
import com.sun.jini.mahout.binder.RefHolder;
import net.jini.lookup.entry.*;

import net.jini.core.entry.*;
import net.jini.core.transaction.server.*;

public class ServerNode implements DiscoveryListener
{

   static final String TX_MANAGER_NAME = "TransactionManager";

   private JavaSpace tpSpace;
   private String spaceToFind;
   private ServiceRegistrar myReg = null;
   private TransactionManager myTxMgr = null;

   public ServerNode()
   { }

   public void discovered(DiscoveryEvent e)
   {
      try
      {
         ServiceRegistrar[] regs = e.getRegistrars();

         for (int i = 0; i < regs.length; i++)
         {
            System.out.println("Registrar " + regs[i].getLocator().toString());
            System.out.println();
            System.out.println("Searching for a JavaSpace called " + spaceToFind + ": ");
            Entry[] entries = new Entry[] {new Name(spaceToFind)};
            tpSpace = (JavaSpace) regs[i].lookup(new ServiceTemplate(null, null, entries));

            System.out.println("INSIDE DISCOVERY... tpSpace is " +
                      ((tpSpace == null) ? "" : "not ") + "null");
            if (tpSpace != null)
            {
               System.out.println("... Space located!");
               myReg = regs[i];
               break;

            }
            else
            {
               System.out.println("... Not found in " + regs[i].getLocator().toString());
            }
         }

         synchronized (this)
         {
            notifyAll();
         }
      }
      catch (Exception err)
      {
         System.out.println("Error: " + err.getMessage());
         err.printStackTrace();
      }
   }

   public void discarded(DiscoveryEvent e)
   {
   }

   public JavaSpace locateSpace(String spaceToLocate)
   {
      spaceToFind = spaceToLocate;
      tpSpace = null;

      try
      {
         LookupDiscovery ld = new LookupDiscovery(LookupDiscovery.ALL_GROUPS);
         ld.addDiscoveryListener(this);

         synchronized (this)
         {
            wait();
         }
      }
      catch (Exception err)
      {
         System.out.println("Error: " + err.getMessage());
         err.printStackTrace();
      }

      return tpSpace;
   }

   protected TransactionManager findTxManager()
   {
      try
      {
         if (myReg != null)
         {
            System.out.println("Looking for a transaction manager on " + myReg.getLocator().toString());
            if (myTxMgr == null)
            {
               myTxMgr = (TransactionManager) myReg.lookup(new ServiceTemplate(null, null,
                        new Entry[] {new Name(TX_MANAGER_NAME)}));
               System.out.println(myTxMgr == null ? "Transaction Manager Found!" : "No Transaction manager found :(");
            }
         }
      }
      catch (Exception err)
      {
         System.out.println("Error: " + err.getMessage());
         err.printStackTrace();
      }

      return myTxMgr;
   }

   static final String INPUT_SPACE = "ServletSpace";
   static final String TEST_USER = "me";
   static final String TEST_ID = "12345";
   static final Double TEST_AMOUNT = new Double(12.45);

   public static void main(String[] args)
   {
      String seekSpace = INPUT_SPACE;
      if (args.length > 0)
      {  seekSpace = args[0]; }

      if (System.getSecurityManager() == null)
      {  System.setSecurityManager(new RMISecurityManager()); }

      JavaSpace space = (new ServerNode()).locateSpace(seekSpace);

      if (space != null)
      {  System.out.println("Got a remote reference to the JavaSpace " + seekSpace); }
      else
      {
         System.out.println("JavaSpace " + seekSpace + " not found. Exiting...");
         System.exit(1);
      }

      UserEntry msg = new UserEntry(TEST_USER, TEST_ID, TEST_AMOUNT, null, null, null);
      Transaction txn = null;
      long timeToLive = Lease.FOREVER;

      try
      {
         space.write(msg, txn, timeToLive);
         System.out.println("Wrote an entry to the space");
         UserEntry template = new UserEntry();
         System.out.println("Created a template");
         long timeToWait = 0L;
         Transaction sotxn = null;
         UserEntry result = (UserEntry) space.read (template, sotxn, timeToWait);
         System.out.println("Read an entry from the space");

         String valueToPrint = "";

         valueToPrint = result.memberID;

         System.out.println("and the result was: " + valueToPrint);
      }
      catch (Exception err)
      {
         System.out.println("Error: " + err.getMessage());
         err.printStackTrace();
      }

      System.exit(0);

   }

}