package com.wrox.javaSpaces;

import com.sun.jini.mahout.binder.RefHolder;
import net.jini.core.lease.*;
import net.jini.space.JavaSpace;
import net.jini.core.transaction.*;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import net.jini.core.transaction.server.*;
import java.util.*;
import net.jini.core.entry.*;

public class TrafficGenerator extends ServerNode
{
   static final String OUT_SPACE1 = "VerifySpace";
   static final String OUT_SPACE2 = "CreditSpace";

   private JavaSpace outSpace1;
   private JavaSpace outSpace2;

   private Random myRand = new Random();

   public TrafficGenerator()
   {
      super();
   }

   public void Initialize()
   {
      if (System.getSecurityManager() == null)
      {  System.setSecurityManager(new RMISecurityManager()); }

      System.out.println("Traffic Generator running...");
      outSpace1 = locateSpace(OUT_SPACE1);
      outSpace2 = locateSpace(OUT_SPACE2);
   }

   public void doWork(int maxIterations)
   {
      System.out.print("Generating...");
      try
      {
         for (int i=0; i<maxIterations; i++)
         {
            UserEntry myEnt = new UserEntry("test user " + myRand.nextInt(), "" + myRand.nextInt(),
                     null, null, null, null);
            outSpace1.write(myEnt, null, Lease.FOREVER);
            outSpace2.write(myEnt, null, Lease.FOREVER);
            System.out.println("..."+ (i+1));
         }
         System.out.println("...Done!");
      }
      catch (Exception err)
      {
         System.out.println(err.getMessage());
         err.printStackTrace();
      }
   }

   public static void main(String[] args)
   {

      int maxItr = 200;

      if (args.length > 0)
      {maxItr = Integer.parseInt(args[0]); }

      TrafficGenerator myNode = new TrafficGenerator();
      myNode.Initialize();
      myNode.doWork(maxItr);
      System.exit(0);
   }
}
