import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;

import java.net.*;

import net.jini.space.JavaSpace;
import net.jini.core.lease.*;

import net.jini.discovery.*;
import net.jini.core.discovery.*;
import net.jini.core.entry.*;
import net.jini.core.lookup.*;
import net.jini.lookup.entry.*;

import com.wrox.javaSpaces.*;

public class JSpaceServlet extends HttpServlet
{

   static final String IN_SPACE1 = "SuccessSpace";
   static final String IN_SPACE2 = "FailureSpace";
   static final String OUT_SPACE1 = "CreditSpace";
   static final String OUT_SPACE2 = "VerifySpace";

   static final String HTML_HEADER = "<HTML><HEAD><TITLE>JavaSpaces Loan Approval System</TITLE></HEAD><BODY>";
   static final String HTML_FOOTER = "</BODY></HTML>";

   static JavaSpace outSpace1,
                    outSpace2,
                    inSpace1,
                    inSpace2;

   public void init() throws ServletException
   {
      System.setProperty("java.rmi.server.codebase", "http://jamesh:8080/wroxjs-dl.jar");
      if (outSpace1 == null)
      {
         log("Initializing...");
         ServerNode sn = new ServerNode();
         outSpace1 = sn.locateSpace(OUT_SPACE1);
         outSpace2 = sn.locateSpace(OUT_SPACE2);
         inSpace1 = sn.locateSpace(IN_SPACE1);
         inSpace2 = sn.locateSpace(IN_SPACE2);
      }
   }

   public void generateRefreshPage(PrintWriter out, String url, String userName, String memberID)
   {
      out.print("<HTML><HEAD><META HTTP-EQUIV=\"REFRESH\" CONTENT=\"30; URL=" + url);
      out.print("?username=");
      out.print(userName);
      out.print("&memberid=");
      out.print(memberID);
      out.println("&dummy=a\"></HEAD><BODY>");
      out.println("<H2>Loan Approval in Progress</H2>");
      out.println("<H3>Please Wait...</H></BODY></HTML>");
   }


   protected UserEntry sucEntry;
   protected UserEntry failEntry;

   public void doGet(HttpServletRequest req, HttpServletResponse res)
           throws ServletException, IOException
   {
      String formFirst[] = req.getParameterValues("forminp");
      String userName = req.getParameter("username");
      String memberID = req.getParameter("memberid");

      if (formFirst != null)
      {
         UserEntry myEnt = new UserEntry(userName, memberID, null, null, null, null);
         try
         {
            outSpace1.write(myEnt, null, Lease.FOREVER);
            outSpace2.write(myEnt, null, Lease.FOREVER);
         }
         catch (Exception err)
         {
            log("Error writing to output JavaSpaces", err);
         }
         log("wrote two entries...");

         res.setContentType("text/html");
         PrintWriter out = new PrintWriter(res.getOutputStream());
         generateRefreshPage(out,req.getRequestURI(),userName, memberID);
         out.close();

         return;
      }

      try
      {
         sucEntry = null;
         failEntry = null;
         sucEntry = (UserEntry) inSpace1.takeIfExists(new UserEntry(userName, memberID,
                                 null, null, null, null), null, JavaSpace.NO_WAIT);
         failEntry = (UserEntry) inSpace2.takeIfExists(new UserEntry(userName, memberID,
                                 null, null, null, null), null, JavaSpace.NO_WAIT);
      }
      catch (Exception err)
      {
         log("Error reading from input JavaSpaces", err);
      }
      
      res.setContentType("text/html");
      PrintWriter out = new PrintWriter(res.getOutputStream());
      if ((sucEntry == null) && (failEntry == null))
      {  generateRefreshPage(out, req.getRequestURI(), userName, memberID); }
      else
      {
         out.println(HTML_HEADER);
         if (sucEntry != null)
         {
            out.print("<H2>Congratulations! Your loan is approved.</H2>");
            out.print("<B>Amount approved: $</B>");
            if(sucEntry.creditLimit != null)
            {  out.println(sucEntry.creditLimit.toString()); }
         }
         else
         {
            out.print("<H2>Sorry, your loan has been rejected.</H2>");
            out.print("<B>Reasons:</B>");
            if (failEntry.verified != null)
            {
               if (!failEntry.verified.booleanValue())
               {  out.print("Membership not found<BR>"); }
            }
            if (failEntry.creditLimit != null)
            {
               if (failEntry.creditLimit.doubleValue() == 0.0)
               {  out.print("credit not approved<BR>"); }
            }
            if (failEntry.verifyFlag != null)
            {
               if (!failEntry.verifyFlag.booleanValue())
               {  out.print("loan center officer rejection<BR>"); }
            }
         }
         out.print("<P><H3>Thankyou for visiting!</H3>" + HTML_FOOTER);
      }

      out.close();
   }

   public String getServletInfo()
   {
      return "JavaSpaces based distributed parallel loan approval system";
   }

}