import java.io.*;
import org.w3c.dom.*;
import org.xml.sax.*;
import org.xml.sax.helpers.ParserFactory;
import org.xml.sax.helpers.AttributeListImpl;
import com.sun.xml.tree.*;
import com.sun.xml.parser.Resolver;

public class Pizzatopping
{
	  
   static boolean toppingElement = false;
   static String toppings[] = new String[10];
   static int toppingsIdx = 0;
	  
   public static void main(String argv []) throws IOException
   {
      InputSource input;
   
      if (argv.length != 1) 
      {
         System.err.println("Usage: cmd filename");
         System.exit (1);
      }
   
      try 
      {
         input = Resolver.createInputSource(new File(argv [0]));
         Parser  parser;
    	 	
         parser = ParserFactory.makeParser();
         parser.setDocumentHandler(new MyDocHandler());
         parser.setErrorHandler(new MyErrorHandler ());
         parser.parse(input);
      }
      catch(SAXParseException err) 
      {
         System.out.println ("** Parsing error" + ", line " + err.getLineNumber () + ", uri " + err.getSystemId ());
         System.out.println("   " + err.getMessage ());
      } 
      catch(SAXException e) 
      {
         Exception   x = e;
         if (e.getException() != null)
         { }
         
         x = e.getException();
         x.printStackTrace();
      } 
      catch(Throwable t) 
      {
         t.printStackTrace();
      }
      System.exit (0);
   }
   	
   static class MyDocHandler extends HandlerBase
   {
         
      public void startElement(String name, AttributeList attributes) throws SAXException 
      {
         if (name.equals("topping")) 
         {
            toppingElement = true;
         }
      }                  
                                  
      public void startDocument() throws SAXException
      {
         System.out.println("Document processing started...");
         toppingElement = true;
      }
   
      public void endDocument() throws SAXException
      {
         System.out.println("The toppings in the menu are:");
   	    	
         for (int i=0; i<toppingsIdx; i++) 
         {
            System.out.println(i+1 + ". " + toppings[i]);
         }
     }
       	
      public void characters(char ch[], int start, int length)
      {
         String output = new String(ch, start, length);
         if (toppingElement) 
         {
            toppings[toppingsIdx] = output;
            toppingsIdx++;
            toppingElement = false;
         }	
      }
   
      public void warning(SAXParseException err) throws SAXParseException
      {
         System.out.println ("** Warning" + ", line " + err.getLineNumber() + ", uri " + err.getSystemId());
         System.out.println("   " + err.getMessage());
      }
   }
   
   static class MyErrorHandler extends HandlerBase
   {
      public void error(SAXParseException err) throws SAXParseException
      {
         System.out.println("** Error" + ", line " + err.getLineNumber() + ", uri " + err.getSystemId());
         System.out.println("   " + err.getMessage());
      }

      // dump warnings too
      public void warning(SAXParseException err) throws SAXParseException
      {
         System.out.println("** Warning" + ", line " + err.getLineNumber() + ", uri " + err.getSystemId());
         System.out.println("   " + err.getMessage());
      }
   }
}

