package com.wrox.pizza;

import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class PizzaMenu
{
   protected String path;
   protected Vector pizzas = new Vector();
   protected int NumOfPizza;
   public String name;
   public String phone;
   public String address;
  
   public PizzaMenu(String path) 
   {
      this.path = path;
   }
  
   public void OrderIt(int index) 
   {
      Pizza tmpPizza = (Pizza)pizzas.elementAt(index);
      tmpPizza.setOrdered();
   }

   public int getNumOfPizza() 
   {
      return NumOfPizza;
   }
	
   public Pizza getPizza(int index) 
   {
    if (index < 0 || index >= pizzas.size()) return null;
    return (Pizza)pizzas.elementAt(index);
   }

   private String[] getFileList()
   {
      File file = new File(path);
      String[] list = file.list();
  	
      Vector vector = new Vector();
      for (int i = 0; i < list.length; i++)
      {
         if (list[i].toLowerCase().endsWith(".xml"))
         {
            vector.addElement(list[i].substring(
                 0, list[i].length() - 4));
         }
      }
      int count = vector.size();
      list = new String[count];
      for (int i = 0; i < list.length; i++)
      {
         list[i] = (String)vector.elementAt(i);
      }
      return list;
   }
  	
   public void buildPizzaMenu() throws IOException 
   {
      String[] list = getFileList();

      for (int i = 0; i < list.length; i++)
      {
         String fullPath = path + File.separator + list[i] + ".xml";
         pizzas.addElement(new Pizza(fullPath));
      }
      NumOfPizza = list.length;
   }
}
