import java.sql.*;
import com.wrox.jspexamples.DbBean;

public class TestDbBean {

   public static void main(String[] argc) {

      DbBean myDbBean = new DbBean();

      myDbBean.setDbDriver("sun.jdbc.odbc.JdbcOdbcDriver");
      myDbBean.setDbURL("jdbc:odbc:techlib");

      int numColumns = 0; 
      String sql = "select authid, lastname, firstname from authors";

      ResultSet rs = null;
      ResultSetMetaData rsmd = null;

      try {
         myDbBean.connect();
      } catch (ClassNotFoundException e) {
         System.out.println("connect() ClassNotFoundException: " + e);
      } catch (SQLException e) {
         System.out.println("connect() SQLException: " + e);
      }

      try {
         rs = myDbBean.execSQL(sql);      
      } catch (SQLException e) {
         System.out.println("execSQL() SQLException: " + e);
      }

      try {
         rsmd = rs.getMetaData();
         numColumns = rsmd.getColumnCount();

         for (int column = 1; column <= numColumns; column++) {
            System.out.println(rsmd.getColumnName(column));
         }

         while (rs.next()) {
            for (int column = 1; column <= numColumns; column++) {
               System.out.println(rs.getString(column));
            } 
         }
         myDbBean.close();
      } catch (SQLException e) {
         System.out.println("Problems with the database - SQLException: " + e);
      }

      // Test for List2.jsp
      ResultSet tables = null; 

      try {
         tables = myDbBean.getTables();
      }
      catch (SQLException e) {
         System.out.println("getTables() SQLException: " + e);
      }

      try {
         while (tables.next()) {
            String current_table = tables.getString("TABLE_NAME");
            System.out.println(current_table); 
            System.out.println(" ");

            ResultSet table = myDbBean.getTable(current_table);
            while (table.next()) {
               System.out.println(table.getString("COLUMN_NAME"));
            }

            System.out.println(" ");
         }

         myDbBean.close();

      } catch (SQLException e) {
         System.out.println("Table listing failed: " + e);
      }
   }
}
