package com.wrox.jspexamples;

import java.io.File;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

public class FileViewerBean
{
   File myDir;
   File[] contents;
   Vector vectorList;
   Iterator currentFileView; 
   File currentFile;

   public FileViewerBean()
   {
      myDir = new File("C:\\jdk1.2.1");
      vectorList = new Vector();
   }

   public String getDirectory()
   {
      return myDir.getPath();
   }

   public void refreshList()
   {
      contents = myDir.listFiles();
      vectorList.clear(); 

      for (int i = 0; i < contents.length; i++)
         vectorList.add(contents[i]);

      currentFileView = vectorList.iterator();
   }

   public boolean nextFile()
   { 
      while (currentFileView.hasNext())
      {
         currentFile = (File)currentFileView.next();
         return true;
      }
      return false;
   }

   public String getFileName()
   {
      return currentFile.getName();
   }
   
   public String getFileSize()
   {
      return new Long(currentFile.length()).toString();
   }

   public String getFileTimeStamp()
   {
      return new Date(currentFile.lastModified()).toString();
   }

   public boolean getFileType()
   {
      return currentFile.isDirectory();
   }
}
