import javax.servlet.*;
import javax.servlet.http.*;

import java.io.*;

import com.wrox.util.*;

/* Retrieves and echoes the available environment */
/* variables found in the request object.         */

public class Env extends HttpServlet 
{

   public void doGet(HttpServletRequest req, HttpServletResponse res)
   throws ServletException, IOException 
   {

    /* Set content type and create a new PrintWriter */
    res.setContentType("text/html");
    PrintWriter out = res.getWriter();

    /* Create a new HTML object to build response page */
    HTML h = new HTML("Environment Variables");
    h.add(HTML.HEADING, "Environment Variables", true);

    /* Add each individual element separately for efficiency */
    h.add(HTML.NORMAL, "SERVER_NAME: ", false);
    h.add(HTML.NORMAL, req.getServerName(), true);
    h.add(HTML.NORMAL, "SERVER_PROTOCOL: ", false);
    h.add(HTML.NORMAL, req.getProtocol(), true);
    h.add(HTML.NORMAL, "SERVER_PORT: ", false);
    h.add(HTML.NORMAL, Integer.toString(req.getServerPort()), true);
    h.add(HTML.NORMAL, "REQUEST_METHOD: ", false);
    h.add(HTML.NORMAL, req.getMethod(), true);
    h.add(HTML.NORMAL, "PATH_INFO: ", false);
    h.add(HTML.NORMAL, req.getPathInfo(), true);
    h.add(HTML.NORMAL, "PATH_TRANSLATED: ", false);
    h.add(HTML.NORMAL, req.getPathTranslated(), true);
    h.add(HTML.NORMAL, "SCRIPT_NAME: ", false);
    h.add(HTML.NORMAL, req.getServletPath(), true);
    h.add(HTML.NORMAL, "QUERY_STRING: ", false);
    h.add(HTML.NORMAL, req.getQueryString(), true);
    h.add(HTML.NORMAL, "REMOTE_HOST: ", false);
    h.add(HTML.NORMAL, req.getRemoteHost(), true);
    h.add(HTML.NORMAL, "REMOTE_ADDR: ", false);
    h.add(HTML.NORMAL, req.getRemoteAddr(), true);
    h.add(HTML.NORMAL, "REMOTE_USER: ", false);
    h.add(HTML.NORMAL, req.getRemoteUser(), true);
    h.add(HTML.NORMAL, "AUTH_TYPE: ", false); 
    h.add(HTML.NORMAL, req.getAuthType(), true);
    h.add(HTML.NORMAL, "CONTENT_TYPE: ", false);
    h.add(HTML.NORMAL, req.getContentType(), true);
    h.add(HTML.NORMAL, "CONTENT_LENGTH: ", false);
    h.add(HTML.NORMAL, Integer.toString(req.getContentLength()), true);
    h.add(HTML.NORMAL, "HTTP_ACCEPT: ", false);
    h.add(HTML.NORMAL, req.getHeader("Accept"), true);
    h.add(HTML.NORMAL, "HTTP_USER_AGENT: ", false);
    h.add(HTML.NORMAL, req.getHeader("User-Agent"), true);
    h.add(HTML.NORMAL, "HTTP_REFERER: ", false);
    h.add(HTML.NORMAL, req.getHeader("Referer"), true);

    /* Output page and close the PrintWriter */
    out.println(h.getPage());
    out.close();
   }

}

