import java.io.*;
import java.net.URLEncoder;
import java.util.*;

import javax.servlet.*;
import javax.servlet.http.*;

public final class I18NServlet extends HttpServlet {

   private Hashtable languageNames = new Hashtable();

   {
      languageNames.put("af", "Afrikaans");
      languageNames.put("sq", "Albanian");
      languageNames.put("eu", "Basque");
      languageNames.put("bg", "Bulgarian");
      languageNames.put("be", "Byelorussian");
      languageNames.put("zh", "Chinese");
      languageNames.put("zh-cn", "Chinese/China");
      languageNames.put("zh-tw", "Chinese/Taiwan");
      languageNames.put("hr", "Croatian");
      languageNames.put("cs", "Czech");
      languageNames.put("da", "Danish");
      languageNames.put("nl", "Dutch");
      languageNames.put("nl-be", "Dutch/Belgium");
      languageNames.put("en", "English");
      languageNames.put("en-bg", "English/United Kingdom");
      languageNames.put("en-us", "English/United States");
      languageNames.put("fo", "Faeroese");
      languageNames.put("fi", "Finnish");
      languageNames.put("fr", "French");
      languageNames.put("fr-be", "French/Belgium");
      languageNames.put("fr-ca", "French/Canada");
      languageNames.put("fr-ch", "French/Switzerland");
      languageNames.put("gl", "Galician");
      languageNames.put("de", "German");
      languageNames.put("de-au", "German/Austria");
      languageNames.put("de-de", "German/Germany");
      languageNames.put("de-ch", "German/Switzerland");
      languageNames.put("el", "Greek");
      languageNames.put("hu", "Hungarian");
      languageNames.put("is", "Icelandic");
      languageNames.put("id", "Indonesian");
      languageNames.put("ga", "Irish");
      languageNames.put("it", "Italian");
      languageNames.put("ja", "Japanese");
      languageNames.put("ko", "Korean");
      languageNames.put("mk", "Macedonian");
      languageNames.put("no", "Norwegian");
      languageNames.put("pl", "Polish");
      languageNames.put("pt", "Portuguese");
      languageNames.put("pt-br", "Portuguese/Brazil");
      languageNames.put("ro", "Romanian");
      languageNames.put("ru", "Russian");
      languageNames.put("gd", "Scots Gaelic");
      languageNames.put("sr", "Serbian");
      languageNames.put("sk", "Slovak");
      languageNames.put("sl", "Slovenian");
      languageNames.put("es", "Spanish");
      languageNames.put("es-ar", "Spanish/Argentina");
      languageNames.put("es-co", "Spanish/Colombia");
      languageNames.put("es-mx", "Spanish/Mexico");
      languageNames.put("es-es", "Spanish/Spain");
      languageNames.put("sv", "Swedish");
      languageNames.put("tr", "Turkish");
      languageNames.put("uk", "Ukrainian");
   }

   public void doGet(HttpServletRequest req, HttpServletResponse res)
      throws ServletException, IOException {

      String ctype;

      String fname = req.getPathTranslated();
      if(fname == null) {
         res.sendError(res.SC_FORBIDDEN);
         return;
      }
      File file = new File(fname);

      if(file.isDirectory()) {
         StringBuffer url = HttpUtils.getRequestURL(req);
         if(!url.toString().endsWith("/")) {
	      url.append('/');
	      res.sendRedirect(url.toString());
	      return;
         } else {
   	     file = new File(file, "index.html");
	     ctype = "text/html";
         }
      } else {
         ctype = getServletContext().getMimeType(fname);
         if(ctype == null) {
            ctype = "text/plain";
         }
      }

      res.setContentType(ctype);

      if(ctype.startsWith("text/")) {
         String selectedLang = req.getParameter("lang");
         File variant;
         String encoding = "8859_1";

         if(file.exists()) {
            variant = file;
         } else if(selectedLang != null) {
	      variant = getSelectedVariant(file, selectedLang);

	      if(variant == null) {
    	         res.sendError(res.SC_NOT_FOUND);
	         return;
	      } else {
	         String s = variant.getName();
	         s = s.substring(s.indexOf("--"));
	         int sep = s.lastIndexOf('.');
	         if(sep != -1) {
	            encoding = s.substring(sep+1);
	         }
            }
         } else {
            String[] variants = getVariants(file);
	      if(variants.length == 0) {
               res.sendError(res.SC_NOT_FOUND);
	         return;
	      }

	      AcceptList langs = new AcceptList(req.getHeader(
                                              "Accept-Language"));
	      String variantName = findVariant(variants, langs);

            res.setHeader("Pragma", "no-cache");
	      res.setHeader("Vary", "Accept-Language");

	      if(variantName == null) {
	         res.setStatus(res.SC_MULTIPLE_CHOICES);
               res.setContentType("text/html");
               PrintWriter out = res.getWriter();
	         out.println("<HTML><HEAD><TITLE>Select a language</TITLE></HEAD>"+"<BODY><H1>Select a language</H1><UL>");

	         String url = URLEncoder.encode(file.getName());

               for(int i=0; i<variants.length; i++) {
	            String v = variants[i];
	            int sep = v.lastIndexOf('.');
	            if(sep != -1) {
                     v = v.substring(0,sep);
                  }
               out.println("<LI><A href=\""+url+"?lang="+v+"\">"+
               languageNameFor(v)+"</A>");
	      }
	      out.println("</UL></BODY></HTML>");
	      out.close();
	      return;
	   } else {
	      variant = new File(file.getParent(),
			     file.getName() + "--" + variantName);
	      int sep = variantName.lastIndexOf('.');
            if(sep != -1) {
	         encoding = variantName.substring(sep+1);
	      }
	   }
      }
         Reader in =
	   new InputStreamReader(new FileInputStream(variant), encoding);
         Writer out = res.getWriter();
         copy(in,out);
         in.close();
         out.close();
      } else if(file.exists()) {
         InputStream in = new FileInputStream(file);
         OutputStream out = res.getOutputStream();
         copy(in,out);
         in.close();
         out.close();
      }
      else res.sendError(res.SC_NOT_FOUND);
   }

   private void copy(InputStream in, OutputStream out) throws IOException {
      int num;
      byte[] ch = new byte[1024];
      while((num = in.read(ch,0,1024)) > 0) out.write(ch,0,num);
   }

   private void copy(Reader in, Writer out) throws IOException {
      int num;
      char[] ch = new char[1024];
      while((num = in.read(ch,0,1024)) > 0) out.write(ch,0,num);
   }

   private String[] getVariants(File file) {
      File dir = new File(file.getParent());
      final String prefix = file.getName() + "--";
      int prefixLength = prefix.length();
      String[] variants = dir.list(new FilenameFilter(){
         public boolean accept(File dir, String name) {
            return name.startsWith(prefix);
	   }
      });
      for(int i=0; i<variants.length; i++) {
         variants[i] = variants[i].substring(prefixLength);
      }
      return variants;
   }

   private String findVariant(String[] variants, AcceptList langs) {
      for(int i=0; i<langs.size(); i++) {
         String lang = langs.nameAt(i).toLowerCase();
         for(int j=0; j<variants.length; j++) {
	      if(variants[j].toLowerCase().startsWith(lang)) {
	         return variants[j];
	      }
         }
      }
      return null;
   }

   private File getSelectedVariant(File file, String lang) {
      File dir = new File(file.getParent());
      final String prefix = file.getName() + "--" + lang.toLowerCase();
      String[] variants = dir.list(new FilenameFilter() {
	   public boolean accept(File dir, String name) {
	      return name.startsWith(prefix);
	   }
	});

      if(variants.length >= 1) {
         return new File(dir, variants[0]);
      } else {
         return null;
      }
   }

   private String languageNameFor(String code) {
      String name = (String)languageNames.get(code.toLowerCase());
      if(name != null) {
         return name;
      } else {
         return code;
      }
   }
}