//Import Servlet Libraries
import javax.servlet.*;
import javax.servlet.http.*;

//Import Java Libraries
import java.util.*;
import java.sql.*;
import java.io.*;

public class CustSvc extends HttpServlet {

   Connection dbCon;

   public void init() throws ServletException {

      try {
         String driverClassName = getInitParameter("JdbcDriver");
         String dbURL = getInitParameter("dbURL");
         Driver driver = (Driver) Class.forName(driverClassName).newInstance();
         DriverManager.registerDriver(driver);
         dbCon = DriverManager.getConnection(dbURL);
      } catch(ClassNotFoundException e) {
         System.out.println("CustSvc: Database driver could not be found.");
         System.out.println(e.toString());
         throw new UnavailableException(this, "Database driver class not found");
      } catch(SQLException e) {
         System.out.println("CustSvc: Error connecting to the database.");
         System.out.println(e.toString());
         throw new UnavailableException(this, "Cannot connect to the database");
      }
   }

   public void doGet(HttpServletRequest req, HttpServletResponse res)
      throws ServletException, IOException {

      PrintWriter out = res.getWriter();
      res.setContentType("text/html");

      String fname = req.getParameter("txtFname");
      String lname = req.getParameter("txtLname");
      String email = req.getParameter("txtEmail");
      String phone = req.getParameter("txtPhone");
      String request = req.getParameter("txtRequest");

      /* Log request in database */
      try {
         Statement s = dbCon.createStatement();
         s.executeUpdate("insert into CustSvc values('" + fname +
                       "','" + lname + "','" + email + "','" + phone + 
                       "','" + request + "','open')");
      } catch (SQLException e) {
         System.out.println(e.toString());
         return;
      }

      /* Send name field to next servlet in the chain */
      out.println(fname + " " + lname);
      out.close();
   }

   public void destroy() {
      /* Close database connection */
      try {
         dbCon.close();
      } catch (Exception e) {
         System.out.println("CustSvc: Error closing database (destroy)");
         System.out.println(e.toString());
      }
   }
}

