package com.wrox.pizza;

import java.io.*;
import java.net.*;
import java.util.*;
import org.w3c.dom.*;
// the following line is not needed for IBM Parser
import org.xml.sax.SAXException;

public class Pizza
{
   protected String filename;
   protected boolean ordered;
   protected String topping;
   protected String size;
   protected String price;

   public Pizza(String filename) 
   {
      this.filename = filename;

      try 
      {
	    Document document = PizzaDOMUtil.readDocument(filename);
  	    Node ntopping = PizzaDOMUtil.findNode(document, "topping");
    	    Node nprice = PizzaDOMUtil.findNode(document, "price");
    	    Node nsize = PizzaDOMUtil.findNode(document, "size");

         this.topping = ntopping.getFirstChild().getNodeValue();
         this.size = nsize.getFirstChild().getNodeValue();
         this.price = nprice.getFirstChild().getNodeValue();
  	 }
  	 catch (IOException e) 
      {
         System.out.println("exception is " + e);
  	 }
  	 catch (SAXException e) 
      {
         System.out.println ("exception is " + e);
      }
   }

   public String getTopping() 
   {
      return topping;
   }

   public String getSize() 
   {
      return size;
   }

   public String getPrice() 
   {
      return price;
   }

   public void setOrdered() 
   {
      this.ordered = true;
   }

   public boolean isOrdered()
   {
      if (ordered) 
         return true;
  	 else
         return false;
   }
}
