package com.wrox.pizza;

import java.io.*;
import org.w3c.dom.*;
// the following line is for IBM parser
//import com.ibm.xml.parser.Parser;

// the following 4 lines are for Sun parser
import com.sun.xml.parser.Resolver;
import com.sun.xml.tree.XmlDocument;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PizzaDOMUtil
{
   public static Document readDocument(String filename)
          throws IOException, SAXException
   {

// if you are using the IBM parser, use the commented lines
    	
//    Parser parser = new Parser(filename);
//    InputStream input = new FileInputStream(filename);
//    Document doc = parser.readStream(input);
//    input.close();
//    return doc;
    	
// if you are using the Sun parser, use these lines
      InputSource input = Resolver.createInputSource(new File(filename));
      XmlDocument doc = XmlDocument.createXmlDocument(input, false);
      doc.getDocumentElement().normalize();
      return doc;

   }

   public static Node findNode(Node node, String name) 
   {
      if (node.getNodeName().equals(name))
         return node;
      if (node.hasChildNodes())
      {
         NodeList list = node.getChildNodes();
         int size = list.getLength();
         for (int i = 0; i < size; i++)
         {
            Node found = findNode(list.item(i), name);
            if (found != null) return found;
         }
      }
      return null;
   }

   public static String getNodeAttribute(Node node, String name) 
   {
      if (node instanceof Element)
      {
         Element element = (Element)node;
         return element.getAttribute(name);
      }
      return null;
   }
 
   public static void printSubtree(PrintWriter writer, Node root, Node node) 
   {
      if (node instanceof Element)
      {
         if (node != root)
            writer.print("\n<" + node.getNodeName() + ">");
         if (node.hasChildNodes())
         {
            NodeList list = node.getChildNodes();
            int size = list.getLength();
            for (int i = 0; i < size; i++)
            {
               printSubtree(writer, root, list.item(i));
            }
         }
         if (node != root)
            writer.print("</" + node.getNodeName() + ">");
      }
      else if (node instanceof Text)
      {
         writer.print(node.getNodeValue().trim());
      }
   }
}
