import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import com.wrox.pizza.*;

public class PizzaServlet extends HttpServlet
{
   public String getParameter(HttpServletRequest req, String name)
   {
      String[] values = req.getParameterValues(name);
      if (values == null) return null;
      return values[0];
   }

   public int getInteger(HttpServletRequest req, String name) 
   {
      String value = getParameter(req, name);
      if (value == null) return -1;
      return Integer.parseInt(value);
   }

   public void exception(HttpServletResponse res,
          Exception exception)
   {
      try
      {
         res.setContentType("text/html");
         PrintWriter out = new PrintWriter(res.getOutputStream());
         out.println("<html><head>");
         out.println("<title>Servlet Exception</title>");
         out.println("</head><body>");
         out.println("<h1>Servlet Error</h1>");
         out.println("<code>");
         exception.printStackTrace(out);
         out.println("</code></body></html>");
      }
      catch (IOException e) {}
   }

   private PizzaMenu getPizzaMenu(HttpServletRequest req, PrintWriter out)
           throws IOException 
   {
      HttpSession session = req.getSession(true);
      Object value = session.getValue("pizzamenu");
      PizzaMenu pizzaMenu = null;
      if (value instanceof PizzaMenu) 
      {
         pizzaMenu = (PizzaMenu)value;
      }
      else
      {
         pizzaMenu = new
           PizzaMenu(getServletContext().getRealPath(getInitParameter("pizzas")));
         pizzaMenu.buildPizzaMenu();
         session.putValue("pizzamenu", pizzaMenu);
      }
      return pizzaMenu;
   }
  
 
   public void service(HttpServletRequest req, HttpServletResponse res)
          throws ServletException, IOException 
   {
      try
      {
         PrintWriter out = new PrintWriter(res.getOutputStream());
         PizzaMenu pizzaMenu = getPizzaMenu(req, out);
    	    
      //assume we are at the start point and then set current accordingly	
         int current = 0;
         if (getInteger(req, "CURRENT_PIZZA") != -1)
         current = getInteger(req, "CURRENT_PIZZA");
    	
    	// if order checkbox was checked, then set the flag

         if (getParameter(req, "ORDER_IT") != null)
         pizzaMenu.OrderIt(current);
    	
    	// handle next and prev buttons
         if (getParameter(req, "NEXT") != null)
            current++;
         if (getParameter(req, "PREV") != null)
            current--;

         String path = req.getRequestURI();
         int pos = path.indexOf('?');
         if (pos > -1) path = path.substring(0, pos);
         String thisURL = "http://" + req.getServerName() + ":8080" + path;

      // if checkout was requested, print Info page
         if (getParameter(req, "CHECKOUT") != null) 
         {
            res.setContentType("text/html");
            PizzaView.getOrderInfoPage(out, thisURL);
         }
    	// if they are done, show the final order
    	    else if (getParameter(req, "FINISH") != null) 
         {
    	       res.setContentType("text/html");
    		 pizzaMenu.name = getParameter(req, "NAME");
    		 pizzaMenu.address = getParameter(req, "ADDRESS");
    		 pizzaMenu.phone = getParameter(req, "PHONE");
    		 PizzaView.getOrderPage(out, thisURL, pizzaMenu, false);
    	    }
    	    else if (getParameter(req, "FINISHXML") != null) 
          {
    	       res.setContentType("text/xml");
    		 pizzaMenu.name = getParameter(req, "NAME");
    		 pizzaMenu.address = getParameter(req, "ADDRESS");
    		 pizzaMenu.phone = getParameter(req, "PHONE");
    		 PizzaView.getOrderPage(out, thisURL, pizzaMenu, true);
    	    }
    	// show another pizza
    	    else 
          {
	       res.setContentType("text/html");
  	       PizzaView.getPizzaPage(out, thisURL, current, pizzaMenu);
    	    }
    	    out.flush();
      }
Continued on Following Page
 
      catch (Exception e)
      {
         exception(res, e);
      }
   }
}
