import java.io.File;
import com.sun.xml.parser.Resolver;
import com.sun.xml.tree.XmlDocument;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class validParser
{
   public static void main (String argv [])
   {
      InputSource     input;
      XmlDocument     doc;

      if (argv.length != 1) 
      {
         System.err.println ("Usage: cmd filename");
         System.exit (1);
      }

      try 
      {
         input = Resolver.createInputSource (new File(argv [0]));
	    doc  = XmlDocument.createXmlDocument (input, true);
         doc.getDocumentElement ().normalize ();
         doc.write (System.out);
      } 
      catch (SAXParseException err) 
      {
         System.out.println ("** Parsing 			error" + ", line " + 
            			err.getLineNumber ()  + 
            			", uri " + err.getSystemId ());
	    System.out.println("   " + 	err.getMessage ());
      } 
      catch (SAXException e) 
      {
          Exception   x = e.getException ();
          ((x == null) ? e : x).printStackTrace ();
      } 
      catch (Throwable t) 
      {
          t.printStackTrace ();
      }
      System.exit (0);
   }
}
