package tapir.weeds;

import java.sql.*;

public class CreateDB {

  String d_dbname;
  
  public static void main(String argv[]) throws Exception {
    CreateDB self=new CreateDB(argv[0]);
    self.run();
  }

  public CreateDB(String dbname) {
    d_dbname=dbname;
  };

  public void run() throws Exception {
    Connection conn=Weeds.getRootConnection();

    Statement s=conn.createStatement();
    s.executeUpdate("CREATE DATABASE "+d_dbname);

    s.close();
    conn.close();

    conn=Weeds.getConnection(d_dbname);
    s=conn.createStatement();

    s.executeUpdate("CREATE TABLE species (id varchar(32),family varchar(64))");
    s.executeUpdate("CREATE TABLE latin (species varchar(32),name varchar(64),principal int)");
    s.executeUpdate("CREATE TABLE common (species varchar(32),name varchar(64),lang char(2))");
    s.executeUpdate("CREATE TABLE text (species varchar(32),type varchar(64),source varchar(64),lang char(2),text text)");
    s.executeUpdate("CREATE TABLE cite (species varchar(32),source varchar(64),page varchar(8))");
    s.executeUpdate("CREATE TABLE images (species varchar(32),type varchar(64),img blob,format varchar(64),height int,width int)");
    s.executeUpdate("CREATE TABLE new_ordering (old_number int,new_number int)");

    s.close();
    conn.close();
  };

}




