package tapir.weeds;

import tapir.weeds.representation.*;
import honeylocust.msxml.parser.ParseException;

import java.io.*;
import java.sql.*;
import java.util.*;

public class GeneralBean {

  Weeds d_weeds;

  public GeneralBean() throws ClassNotFoundException,SQLException {
    d_weeds=new Weeds();
  };

  public String getRobotInfo() {
    return "ALL";
  };

  public String getAuthor() {
    return "Olivia S. Direnzo and Paul A. Houle";
  };

  public java.util.Date getDate() {
    return new java.util.Date();
  };

  public String getCopyright() {
    return "&copy; 1998 Honeylocust Media Systems (http://www.honeylocust.com/)";
  };

  public String getDescription() {
    return "A collection of descriptions and illustrations of weeds observed in El Limon,  a small village in the Dominican Republic during January 1998. ";
  };

  public String getKeywords() throws SQLException {
    return "El Limon,Weeds,Botany,xml";
  };

  public String getLanguage() {
    return "en";
  };

  public String getVersion() {
    return "2.0";
  };

  public String getNumberNav(int id) {
    StringBuffer out=new StringBuffer();
    
    for(int i=1;i<15;i++) {

      if (i!=1) {
	out.append(" | ");
      };

      if (i!=id) {
	out.append("<A HREF=\""+i+".html\">");
      } else
	out.append("&lt;");
      
      out.append(i);

      if (i!=id) {
	out.append("</A>");
      } else
	out.append("&gt;");

    };

    return out.toString();
  };

  public String toHtml(LanguageString l) {
    if (l.getLanguage()==getLanguage()) {
      return l.toString();
    } else {
      return "<SPAN LANG=\""+l.getLanguage()+"\">"+l.toString()+"</SPAN>";
    };
  };

  public String[] toHtml(LanguageString l[]) {
    int len=l.length;
    String[] x=new String[len];
    for(int i=0;i<len;i++)
      x[i]=toHtml(l[i]);
    
    return x;
  };

  public String toCommaList(String s[]) {
    int len=s.length;
    StringBuffer out=new StringBuffer();
    for(int i=0;i<len;i++) {
      if (i!=0)
	out.append(",");

      out.append(s[i]);
    };

    return out.toString();
  };
  
};





