package tapir.weeds;

import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.io.File;

public class GifInfo {

  Toolkit d_tool;

  public final static boolean debug=true;

  public GifInfo() {
    if (debug)
      System.err.println("About to get awt.Toolkit");
    d_tool=(new Panel()).getToolkit();
    if (debug)
      System.err.println("got awt.Toolkit");

  };

  public int[] getDimensions(File f) throws InterruptedException {
    return getDimensions(f.getAbsolutePath());
  };
	
  public int[] getDimensions(String s) throws InterruptedException {
    Image i=d_tool.getImage(s);
    int x[]=new int[2];

    GifInfoObserver o=new GifInfoObserver(ImageObserver.ALLBITS);
    synchronized(o) {
      d_tool.prepareImage(i,-1,-1,o);
      o.wait();
    }

    x[1]=i.getHeight(null);
    x[0]=i.getWidth(null);

    i.flush();
    return x;
  };

/*
  int getWidth(Image i) throws InterruptedException {
    GifInfoObserver o=new GifInfoObserver(ImageObserver.WIDTH);
    int width=-1;
    synchronized(o) {
      width=i.getWidth(o);
      if (width==-1) {
	o.wait();
	width=o.d_width;
      };
    };

      return width;
  };

  int getHeight(Image i) throws InterruptedException {
    GifInfoObserver o=new GifInfoObserver(ImageObserver.HEIGHT);
    int height=-1;
    synchronized(o) {
      height=i.getHeight(o);
      if (height==-1) {
	o.wait();
	height=o.d_height;
      };
    };

      return height;
  };

*/

  class GifInfoObserver implements ImageObserver {
    int d_waitFor;

    public GifInfoObserver(int waitFor) {
      d_waitFor=waitFor;
    };

    public synchronized boolean imageUpdate(Image i,int flags,int x,int y,int width,int height) {
      
      if ((flags&ImageObserver.ERROR)!=0) {
	if (debug)
	  System.out.println("Error in imageUpdate.");

	notify();
	return false;
      };

      if ((flags&d_waitFor)!=0)
	return true;

      notify();
      return false;
    };
  };
  
  public static void main(String argv[]) throws Exception {
    GifInfo g=new GifInfo();
    for(int i=0;i<argv.length;i++) {
      int x[]=g.getDimensions(argv[i]);
      System.out.println(argv[i]+": " +x[0]+"x"+x[1]);      
    };
    System.exit(0);
  };
};












