package tapir.weeds;

import java.io.*;
import java.sql.*;

import tapir.weeds.representation.*;

public class Weeds {

  public String d_dbname="weeds";
  public Connection d_conn;

  public Weeds() throws ClassNotFoundException,SQLException {
    d_conn=getConnection(d_dbname);
  };

  public static Connection getConnection(String dbname) throws ClassNotFoundException,SQLException {
    Class.forName("org.gjt.mm.mysql.Driver");
    return DriverManager.getConnection("jdbc:mysql://localhost/"+dbname,"root","");
  };

  public static Connection getRootConnection() throws ClassNotFoundException,SQLException {
    return getConnection("mysql");
  };

  public PreparedStatement prepareStatement(String stmt) throws SQLException {
    return d_conn.prepareStatement(stmt);
  };

  public String getOldId(String newId) throws SQLException {
    return selectFromNewOrdering(newId).getString(1);
  };

  public void insertImage(String species,String type,File file,String format,int width,int height) throws SQLException,FileNotFoundException {
    PreparedStatement ps=prepareStatement("INSERT INTO images (species,type,img,format,width,height) values (?,?,?,?,?,?)");
    ps.setString(1,species);
    ps.setString(2,type);
    storeFileInBlob(ps,3,file);
    ps.setString(4,format);
    ps.setInt(5,width);
    ps.setInt(6,height);
    ps.executeUpdate();
  };

  public void storeFileInBlob(PreparedStatement ps,int slot,File f) throws SQLException,FileNotFoundException {
    int length=(int) f.length();
    FileInputStream in=new FileInputStream(f);

    ps.setBinaryStream(slot,in,length);
  };
  
  public void insertWeed(Species s) throws SQLException {
    if (s.getFamily()==null)
      throw new IllegalArgumentException("Weed not identified");
    
    String id=s.getId();
    insertIntoSpecies(id,s.getFamily().toString());
    LanguageString l[]=s.getLatin();
    for (int i=0;i<l.length;i++) {
      insertIntoLatin(id,l[i].toString(),i==0);
    }

    l=s.getCommon();
    for (int i=0;i<l.length;i++) {
      insertIntoCommon(id,l[i]);
    }

    Text t[]=s.getTexts();
    for (int i=0;i<t.length;i++) {
      insertIntoText(id,t[i]);
    }

    
  };
  
  private void insertIntoSpecies(String id,String family) throws SQLException {
    PreparedStatement ps=prepareStatement("INSERT INTO species (id,family) values (?,?)");
    ps.setString(1,id);
    ps.setString(2,family);
    ps.executeUpdate();
  };

  private void insertIntoLatin(String id,String name,boolean principal) throws SQLException {
    PreparedStatement ps=prepareStatement("INSERT INTO latin (species,name,principal) values (?,?,?)");
    ps.setString(1,id);
    ps.setString(2,name);
    ps.setInt(3,principal ? 1 : 0);
    ps.executeUpdate();
  };

  private void insertIntoCommon(String id,LanguageString name) throws SQLException {
    PreparedStatement ps=prepareStatement("INSERT INTO common (species,name,lang) values (?,?,?)");
    ps.setString(1,id);
    ps.setString(2,name.toString());
    ps.setString(3,name.getLanguage());
    ps.executeUpdate();
  };

  private void insertIntoText(String id,Text t) throws SQLException {
    PreparedStatement ps=prepareStatement("INSERT INTO text (species,type,source,lang,text) values (?,?,?,?,?)");
    ps.setString(1,id);
    ps.setString(2,t.getType());
    ps.setString(3,t.getSource());
    ps.setString(4,t.getLanguage());
    ps.setString(5,textToXML(t));
    ps.executeUpdate();
  };

  public ResultSet selectFromNewOrdering(String new_number) throws SQLException {
    PreparedStatement ps=prepareStatement("SELECT old_number FROM new_ordering WHERE new_number=?");
    ps.setString(1,new_number);
    return ps.executeQuery();
  };

  public ResultSet selectFromSpecies(String id) throws SQLException {
    PreparedStatement ps=prepareStatement("SELECT family FROM species WHERE id=?");
    ps.setString(1,id);
    return ps.executeQuery();
  };

  public ResultSet selectFromLatin(String id) throws SQLException {
    PreparedStatement ps=prepareStatement("SELECT name FROM latin WHERE species=?");
    ps.setString(1,id);
    return ps.executeQuery();
  };

  public ResultSet selectFromCommon(String id) throws SQLException {
    PreparedStatement ps=prepareStatement("SELECT name,lang FROM common WHERE species=?");
    ps.setString(1,id);
    return ps.executeQuery();
  };

  public ResultSet selectFromTexts(String id) throws SQLException {
    PreparedStatement ps=prepareStatement("SELECT type,source,lang,text FROM text WHERE species=?");
    ps.setString(1,id);
    return ps.executeQuery();
  };

  public ResultSet selectSizeFromImages(String id,String type) throws SQLException {
    PreparedStatement ps=prepareStatement("SELECT width,height FROM images WHERE species=? AND type=?");
    ps.setString(1,id);
    ps.setString(2,type);
    return ps.executeQuery();
  };

  public ResultSet selectFromImages(String id,String type) throws SQLException {
    PreparedStatement ps=prepareStatement("SELECT format,img FROM images WHERE species=? AND type=?");
    ps.setString(1,id);
    ps.setString(2,type);
    return ps.executeQuery();
  };

  public ResultSet selectForIndex() throws SQLException {
    PreparedStatement ps=prepareStatement("SELECT species.family,latin.name FROM species,latin WHERE latin.principal=1 AND species.id=latin.species ORDER BY family,latin.name");
    return ps.executeQuery();
  };

  public ResultSet selectFromCommon() throws SQLException {
    PreparedStatement ps=prepareStatement("SELECT name,new_number FROM common,new_ordering WHERE old_number=species ORDER BY name");
    return ps.executeQuery();
  };

  public int getMaxId() throws SQLException{
    PreparedStatement ps=prepareStatement("SELECT MAX(new_number) FROM new_ordering");
    ResultSet rs=ps.executeQuery();
    return rs.getInt(1);
  };

  public int getMinId() throws SQLException{
    PreparedStatement ps=prepareStatement("SELECT MIN(new_number) FROM new_ordering");
    ResultSet rs=ps.executeQuery();
    return rs.getInt(1);
  };

  public String textToXML(Text t) {
    StringBuffer sb=new StringBuffer();
    TextChunk[] chunks=t.getChunks();
    for(int i=0;i<chunks.length;i++) {
      addChunk(sb,chunks[i]);
    };

    return sb.toString();
  };

   void addChunk(StringBuffer sb,TextChunk chunk) {
    if (chunk instanceof AnchorChunk) {
      addAnchorChunk(sb,(AnchorChunk) chunk);
    } else if (chunk instanceof RefChunk) {
      addRefChunk(sb,(RefChunk) chunk);
    } else if (chunk instanceof CMChunk) {
      addCMChunk(sb,(CMChunk) chunk);
    } else
      addPlainChunk(sb,(PlainChunk) chunk);
  };

   void addAnchorChunk(StringBuffer sb,AnchorChunk chunk) {
    sb.append("<A HREF='"+chunk.getHref()+"'>"+chunk.getText()+"</A>");
  };

   void addRefChunk(StringBuffer sb,RefChunk chunk) {
    sb.append("<REF ID='"+chunk.getId()+"'/>");
  };

   void addCMChunk(StringBuffer sb,CMChunk chunk) {
    sb.append("<CM>");
    sb.append(chunk.getText());
    sb.append("</CM>");
  };

   void addPlainChunk(StringBuffer sb,TextChunk chunk) {
    sb.append(chunk.getText());
  };

  public Integer plantNumber(DBSpecies s) {
    
    boolean numeric=true;
    int myNumber=0;
    
    try {
      myNumber=Integer.parseInt(s.getId());
    } catch(NumberFormatException e) {
      numeric=false;
    };
    
    if (!numeric)
      return null;
    
    return new Integer(myNumber);
  };

  public LanguageString speciesName(DBSpecies s) throws SQLException {
    return((s.getLatin())[0]);
  };

  public void reorderWeeds() throws SQLException {
    Statement s=d_conn.createStatement();
    PreparedStatement ps=prepareStatement("INSERT INTO new_ordering (new_number,old_number) VALUES (?,?)");
    ResultSet rs=s.executeQuery("SELECT species.id FROM species,latin WHERE latin.principal=1 AND species.id=latin.species ORDER BY family,latin.name");
    int i=1;
    while(rs.next()) {
      //      System.out.println(i+" "+rs.getInt(1));
      ps.setInt(1,i);
      ps.setInt(2,rs.getInt(1));
      ps.executeUpdate();
      i++;
    };
  };





};










