package com.wrox.context.chat;

import java.util.*;

public class ChatRoom
{
   private static final int MAX_ENTRIES = 5;
   private String name;
   private String description;
   private Vector chatEntries = new Vector();
   public ChatRoom(String name, String description)
   {
      this.name = name;
      this.description = description;
   }

   public synchronized void addChatEntry(ChatEntry entry)
   {
      chatEntries.addElement(entry);
      if (chatEntries.size() > MAX_ENTRIES)
      {
         chatEntries.removeElementAt(0);
      }
   }

   public Enumeration getChatEntries()
   {
      return chatEntries.elements();
      }

   public String getDescription()
   {
      return description;
   }

   public String getName()
   {
      return name;
   }
}
