import javax.servlet.*;
import javax.servlet.http.*;

import java.io.*;
import java.net.*;
import java.util.*;

import com.wrox.context.chat.*;

public class ChatRoomServlet extends HttpServlet
{

   public void doGet(HttpServletRequest req, HttpServletResponse res) 
                  throws IOException, ServletException
   {
        
      res.setContentType("text/html");
      PrintWriter out = res.getWriter();

      ChatRoom room = getRoom(req, res);
      if (room == null)
      {
         return;
      }
        
      // Check if it's a request for a message list or a form
      String listPar = req.getParameter("list");
      if (listPar != null && listPar.equals("true"))
      {
         writeMessages(out, room, getAvatarName(req));
      }
      else
      {
         writeForm(out);
      }
      out.close();
   }
        
   public void doPost(HttpServletRequest req, HttpServletResponse res) 
                 throws IOException, ServletException
   {

      res.setContentType("text/html");
      PrintWriter out = res.getWriter();
 
      ChatRoom room = getRoom(req, res);
      if (room == null)
      {
          return;
      }
      String avatarName = getAvatarName(req);

      // Save message if any
      String msg = req.getParameter("msg");
      if (msg != null && msg.length() != 0)
      {
         room.addChatEntry(new ChatEntry(avatarName, msg));
      }
      writeFrame(out, room);
      out.close();
   }

   private String getAvatarName(HttpServletRequest req) {
      HttpSession session = req.getSession();
      String avatarName = (String) session.getValue("avatarName");
      if (avatarName == null)
      {
         // Entered a room for the first time?
         avatarName = req.getParameter("avatarName");
         if (avatarName == null || avatarName.length() == 0)
         {
            avatarName = "A spineless spy";
         }
         session.putValue("avatarName", avatarName);
      }
      else
      {
         // Entered a new room with a new name?
         String newName = req.getParameter("avatarName");
         if (newName != null && newName.length() > 0 && 
                  !newName.equals(avatarName))
         {
            avatarName = newName;
            session.putValue("avatarName", avatarName);
         }
      }
      return avatarName;
   }

   private ChatRoom getRoom(HttpServletRequest req, HttpServletResponse res) 
              throws IOException
   {

      HttpSession session = req.getSession();
      PrintWriter out = res.getWriter();
       
      String roomName = (String) session.getValue("roomName");
      if (roomName == null)
      {
         // Just entered?
         roomName = req.getParameter("roomName");
         if (roomName == null || roomName.length() == 0)
         {
            writeError(out, "Room not specified");
            return null;
         }
         session.putValue("roomName", roomName);
      }
      else {
         // Entered a new room?
         String newRoom = req.getParameter("roomName");
         if (newRoom != null && newRoom.length() > 0 && 
            !newRoom.equals(roomName))
         {
            roomName = newRoom;
            session.putValue("roomName", roomName);
         }
      }

      RoomList roomList = 
         (RoomList) getServletContext().getAttribute("roomList");
      ChatRoom room = roomList.getRoom(roomName);
      if (room == null)
      {
         writeError(out, "Room " + roomName + " not found");
         return null;
      }
      return room;
   }

   private void writeError(PrintWriter out, String msg)
   {
            
      out.println("<HTML>");
      out.println("<HEAD><TITLE>Error</TITLE></HEAD>");
      out.println("<BODY>");
      out.println("<H1>Error</H1>");
      out.println(msg);
      out.println("</BODY></HTML>");
   }

   private void writeForm(PrintWriter out)
   {
      out.println("<HTML>");
      out.println("<BODY>");
      out.println("<FORM METHOD=POST ACTION=chatRoom TARGET=_top>");

      // Add field for new message
      out.println("<P>Enter your message:<P>");
      out.println("<TEXTAREA NAME=msg COLS=50 ROWS=3 WRAP=HARD>");
      out.println("</TEXTAREA>");
       
      // Add submit button and hidden field with room name
      out.println("<P><INPUT TYPE=SUBMIT VALUE='Send Message'>");

      // Add an Exit button
      out.println("</FORM>");
      out.println("<FORM ACTION=listRooms METHOD=GET TARGET=_top>");
      out.println("<INPUT TYPE=SUBMIT VALUE=Exit>");
      out.println("</FORM>");

      out.println("</BODY></HTML>");
   }

   private void writeFrame(PrintWriter out, ChatRoom room)
   {
            
      out.println("<HTML>");
      out.println("<HEAD><TITLE>" + room.getName() + "</TITLE></HEAD>");
      out.println("<FRAMESET ROWS='60%,30%' BORDER=0 FRAMEBORDER=NO>");
      out.println("<FRAME SRC=chatRoom?list=true NAME=list SCROLLING=AUTO>");
      out.println("<FRAME SRC=chatRoom?list=false NAME=form SCROLLING=AUTO>");
      out.println("<NOFRAMES>");
      out.println("<BODY>");
      out.println("Viewing this page requires a browser capable of displaying frames.");
      out.println("</BODY>");
      out.println("</NOFRAMES>");
      out.println("</FRAMESET>");
      out.println("</HTML>");
   }

   private void writeMessages(PrintWriter out, ChatRoom room,
       String avatarName)
   {
            
      out.println("<HTML>");
      out.println("<HEAD><META http-equiv=\"refresh\" content=\"5\"></HEAD>");
      out.println("<BODY>");
      out.println("<H1>You're in " + room.getName() + " as " +
         avatarName + "</H1>");
        
      // List all messages in the room
      Enumeration entries = room.getChatEntries();
      if (!entries.hasMoreElements())
      {
          out.println("<FONT COLOR=RED>There are no messages in this room yet</FONT>");
      }
      while (entries.hasMoreElements())
      {
         ChatEntry entry = (ChatEntry) entries.nextElement();
         String entryName = entry.getAvatarName();
         if (entryName.equals(avatarName))
         {
            out.print("<FONT COLOR=BLUE>");
         }
         out.println(entryName + " : " + entry.getChatMessage() + 
              "<BR>");
         if (entryName.equals(avatarName))
         {
            out.print("</FONT>");
         }
      }
      out.println("</BODY></HTML>");
   }
}