package com.wrox.util;

public class HTML
{

   public static final int NORMAL   = 0;
   public static final int HEADING  = 1;
   public static final int LINE     = 2;

   public StringBuffer buffer;

   public HTML(String title)
   {
      buffer = new StringBuffer(4096);
      this.buffer.append("<HTML><HEAD><TITLE>");
      this.buffer.append(title);
      this.buffer.append("</TITLE></HEAD><BODY>");
   }

   public void add(int style, String text, boolean linebreak)
   {
      switch(style)
      {
         case NORMAL:
            this.buffer.append(text);
            break;
         case HEADING:
            this.buffer.append("<H1>");
            this.buffer.append(text);
            this.buffer.append("</H1>");
            break;
         case LINE:
            this.buffer.append("<HR>");
            break;
         default:
            break;
      }
      if(linebreak)
      {
         buffer.append("<BR>");
      }
   }

   public String getPage()
   {
      this.buffer.append("</BODY></HTML>");
      return this.buffer.toString();
   }
}
