package data;

import java.sql.*;
import java.util.*;

/**
 *		Provides JDBC access to database for search queries
 */
public class Dbquery extends Dbaccess{
// System.out. useful with servlet runner

	PreparedStatement clearHitlistSQL;		
	PreparedStatement query0SQL;
	PreparedStatement query1SQL;
	PreparedStatement query2SQL;
	PreparedStatement query3SQL;
	PreparedStatement query4SQL;
	PreparedStatement getHitsSQL;

/**
 *		Copies all records from SITES table containing keyword into HITLIST table
 */
	public void findHits(String key){
		try{
			clearHitlistSQL.executeUpdate();
			key = "% "+key+" %"; // SQL wildcards, note spaces
			query0SQL.setString(1, key); 
			query0SQL.executeUpdate();
//			query0SQL.close();
			query1SQL.setString(1, key); 
			query1SQL.executeUpdate();
	//		query1SQL.close();
			query2SQL.setString(1, key); 
			query2SQL.executeUpdate();
	//		query2SQL.close();
			query3SQL.setString(1, key); 
			query3SQL.executeUpdate();
//			query3SQL.close();
			query4SQL.setString(1, key); 
			query4SQL.executeUpdate();
//			query4SQL.close();
			}catch (SQLException sqle){
			 	System.out.println(sqle.toString()); 
			  }
	}

/**
 *		Gets stuff from HITLIST table
 */
	public Vector getHits(){
		String hit = new String();
		Vector hits = new Vector();

		try{
			ResultSet results = getHitsSQL.executeQuery();
			while (results.next()) {
				hit = "<A HREF=";
				hit += results.getString("URL");
				hit += ">";
				hit += results.getString("TITLE");
				hit += "</A>&nbsp;&nbsp;&nbsp;<B>Score :</B>&nbsp; ";
				hit += (new Integer(results.getInt("SCORE"))).toString();
				hit += "<BR><B>Description :</B>&nbsp; ";
				hit += results.getString("DESCRIPTION");
				hit += "<BR><B>Keywords :&nbsp; </B>";
				hit += results.getString("KEYWORDS");
				hit += "<BR><B>Text :</B>&nbsp; ";
				hit += results.getString("PAGETEXT");
				hit += "<BR><B>Citations :</B>&nbsp;";
				hit += (new Integer(results.getInt("INLINKS"))).toString();
				hit += " &nbsp; &nbsp; ";
				hit += results.getString("LINKTEXT");
				hit += "<BR><B>Links :</B>&nbsp;";
				hit += (new Integer(results.getInt("OUTLINKS"))).toString();
				hit += "&nbsp; &nbsp; &nbsp; &nbsp; <B>Last Crawled :</B>&nbsp; ";
				hit += results.getTimestamp("STAMP").toString();
				hit += "<P>";
				hits.add(hit);
			}
		}catch (SQLException sqle){
			 	System.out.println(sqle.toString()); 
			  }
		return hits;
	}


/**
 *		Prepares SQL statements
 */
	public void prepareSQL() {
		try{
			clearHitlistSQL = connection.prepareStatement("DELETE FROM HITLIST");

			query0SQL = connection.prepareStatement("INSERT INTO HITLIST "+
				"SELECT SITES.*,1 AS SCORE FROM SITES WHERE (SITES.PAGETEXT LIKE ?)");

			query1SQL = connection.prepareStatement("UPDATE HITLIST SET HITLIST.SCORE = [HITLIST].[SCORE] + 5 "+
				"WHERE HITLIST.TITLE LIKE ?");

			query2SQL = connection.prepareStatement("UPDATE HITLIST SET HITLIST.SCORE = [HITLIST].[SCORE] + 2 "+
				"WHERE HITLIST.DESCRIPTION LIKE ?");

			query3SQL = connection.prepareStatement("UPDATE HITLIST SET HITLIST.SCORE = [HITLIST].[SCORE] + 3 "+
				"WHERE HITLIST.KEYWORDS LIKE ?");

			query4SQL = connection.prepareStatement("UPDATE HITLIST SET HITLIST.SCORE = [HITLIST].[SCORE] + 4 "+
				"WHERE HITLIST.LINKTEXT LIKE ?");

			getHitsSQL = connection.prepareStatement("SELECT HITLIST.* FROM HITLIST ORDER BY HITLIST.SCORE DESC");
		}catch (SQLException sqle){
		 	System.out.println(sqle.toString()); 
		 }
	}
}

