import java.io.*;
import java.util.*;
import java.text.*;

import javax.servlet.*;
import javax.servlet.http.*;

import javax.naming.*;
import javax.naming.directory.*;

public class CustomerServlet extends HttpServlet {

   public static String MY_PACKAGE_BASE = "ou=Packages,o=fedup.com";
   public static String MY_CUSTOMER_BASE = "ou=Customers,o=fedup.com";
   public static String INITCTX = "com.sun.jndi.ldap.LdapCtxFactory";
   public static int MY_PORT = 389;
   public static String MY_HOST = "ldap://localhost:" + MY_PORT;
   public static String MY_MGR = "cn=Directory Manager";
   public static String MY_PWD = "password";
   public static String MY_SEARCHBASE = "o=fedup.com";

   public static int nextPackageID = 5555;

   // In order to get the right starting package ID, we need to read all existing packages.
   public void init() throws ServletException {
      String[] packaging = { "packageid" };
      Hashtable env = new Hashtable();
  
      env.put(Context.INITIAL_CONTEXT_FACTORY, INITCTX);
      env.put(Context.PROVIDER_URL, MY_HOST);
      
      try {
         // Get a reference to a directory context
         DirContext ctx = new InitialDirContext(env);

         // Perform the search 
         NamingEnumeration results = ctx.search(MY_PACKAGE_BASE, null, packaging);

         while (results != null && results.hasMore()) {
            SearchResult sr = (SearchResult) results.next();
            Attributes attrs = sr.getAttributes();
	   
            Attribute attr = attrs.get("packageid");
            Integer packageNumber = new Integer((String) attr.get());
            if (nextPackageID <= packageNumber.intValue()) {
               nextPackageID = packageNumber.intValue() + 1;
            }   
         }
      } catch (NamingException e) {
         log("Naming exception: " + e);
      }
   } 

   public void doGet(HttpServletRequest req, HttpServletResponse res)
                                 throws ServletException, IOException {
      res.setContentType("text/html");
      PrintWriter out = res.getWriter();
    
      // Get Authorization header
      String auth = req.getHeader("Authorization");

      // Do we allow that user
      if (!allowedUser(auth)) {
         // Not Allowed, so report unauthorized
         res.setStatus(res.SC_UNAUTHORIZED);
         res.setHeader("WWW-Authenticate", "BASIC realm=\"users\"");
      } else {
         // User is allowed in
         out.println("<html><head><title>FedUp Customer Service</title></head><body>");
         out.println("<h2>FedUp Customer Service</h2>");

         String userpassEncoded = auth.substring(6);
         sun.misc.BASE64Decoder dec = new sun.misc.BASE64Decoder();
         String userpassDecoded = new String(dec.decodeBuffer(userpassEncoded));
         StringTokenizer st = new StringTokenizer(userpassDecoded,":");
         String customerid = st.nextToken();
         String pwd = st.nextToken();

         try {
            Customer c = getCustomer(customerid,out);
            Attributes attrs = c.getAttributes();
            Attribute attr = attrs.get("cn");
            out.println("Hello " + attr.get() + "<br>");
            out.println("Your customerid is " + customerid);
            String packageids[] = req.getParameterValues("packageid");
            String actions[] = req.getParameterValues("action"); 

            if (packageids != null) {
               // If you've requested a package, go and list it
               packageLocation(packageids[0],out);
            } else if (actions != null) {
               // Print out the form to add a package
               printAddPackageForm(customerid,out);
            } else {
               // Print off end of welcome page and get all tracked packages
               out.println("<hr><a href=\"CustomerServlet?action=ADD\">Add a new package to track</a>");
               printCustomerPackages(c,out);
            }
         } catch(NamingException x) {
            log("ERROR:Try to Get Customer object for user " + customerid + ": " + x.toString());
            out.println("No customer matching " + customerid);
         } catch(NullPointerException n) {
            log("ERROR:Trying to get Customer object for user " + customerid+": " + n.toString());
            out.println("NullPointer for Customer " + customerid);
         }

         out.println("</body></html>"); 
      }
   }

   // Handle POST request
   public void doPost(HttpServletRequest req, HttpServletResponse res) 
                                              throws ServletException, IOException {
      res.setContentType("text/html");
      PrintWriter out = res.getWriter();

      // Get Authorization header
      String auth = req.getHeader("Authorization");

      // Do we allow that user
      if (!allowedUser(auth)) {
         // Not Allowed, so report he's unauthorized
         res.setStatus(res.SC_UNAUTHORIZED);
         res.setHeader("WWW-Authenticate", "BASIC realm=\"users\"");
      } else {
         // User is allowed in
         out.println("<html><head><title>FedUp Add Package Service</title></head><body>");
         out.println("<h2>FedUp Add Package Service</h2>");

         String userpassEncoded = auth.substring(6);
         sun.misc.BASE64Decoder dec = new sun.misc.BASE64Decoder();
         String userpassDecoded = new String(dec.decodeBuffer(userpassEncoded));
         StringTokenizer st = new StringTokenizer(userpassDecoded,":");
         String customerid = st.nextToken();

         String shipperids[] = req.getParameterValues("sender");
         String receiverids[] = req.getParameterValues("receiver");

         try {
            out.println("Shipper is " + shipperids[0] + "<br>");
            out.println("Receiver is " + receiverids[0] + "<br>");

            addNewPackage(shipperids[0], receiverids[0],out);
         } catch(NullPointerException ne) {
            out.println("Shipper or Receiver not set!<br>");
            out.println("<pre>" + ne.toString() + "</pre>");
         } catch(NamingException nx) {
            out.println("Package couldn't be added<br>");
            out.println(nx.toString());
         } catch(ParseException pe) {
            out.println("Package couldn't be added<br>");
            out.println(pe.toString());
         }
      }
   }

   // This method checks to see if the user is in the LDAP database
   protected boolean allowedUser(String auth) throws IOException {

      Hashtable env = new Hashtable();   
      boolean status = false;

      try {
         if (auth == null) return false; // no auth

         if (!auth.toUpperCase().startsWith("BASIC ")) {
            return false; //only do BASIC
         }

         // Get encoded user and password, comes after BASIC
         String userpassEncoded = auth.substring(6);

         // Decode it, using any base 64 decoder
         sun.misc.BASE64Decoder dec = new sun.misc.BASE64Decoder();
         String userpassDecoded = new String(dec.decodeBuffer(userpassEncoded));
         StringTokenizer st = new StringTokenizer(userpassDecoded,":");
         String customerid = st.nextToken();
         String pwd = st.nextToken();

         // Prepare for context
         env.put(Context.INITIAL_CONTEXT_FACTORY, INITCTX);
         env.put(Context.PROVIDER_URL, MY_HOST);

         // Get a reference to a directory context
         DirContext ctx = new InitialDirContext(env);

         // Specify the scope of the search
         SearchControls constraints = new SearchControls();
         constraints.setSearchScope(SearchControls.SUBTREE_SCOPE);

         // Perform the actual search
         // We give it a searchbase, a filter and a the constraints
         // containing the scope of the search
         NamingEnumeration results = 
                              ctx.search(MY_CUSTOMER_BASE, "(customerid=" + customerid + ")", constraints);

         String dn = null; 

         // Now step through the search results
         while (results != null && results.hasMore()) {
            SearchResult sr = (SearchResult) results.next();
            dn = sr.getName() + "," + MY_CUSTOMER_BASE;
         }

         env.put(Context.SECURITY_AUTHENTICATION, "simple");
         env.put(Context.SECURITY_PRINCIPAL, dn);
         env.put(Context.SECURITY_CREDENTIALS, pwd);

         try {
            DirContext ctx2 = new InitialDirContext(env);
            status = true;        
         } catch (AuthenticationException e) {
            log(e.toString());
         } 
      } catch (NamingException x) {
         log(x.toString());
      }
      return status; 
   }

   protected Customer getCustomer(String customerid, PrintWriter out) 
                          throws NamingException  {
      Hashtable env = new Hashtable();  

      env.put(Context.INITIAL_CONTEXT_FACTORY, INITCTX);
      env.put(Context.PROVIDER_URL, MY_HOST);

      // Get a reference to a directory context
      DirContext ctx = new InitialDirContext(env);

      SearchControls constraints = new SearchControls();
      constraints.setSearchScope(SearchControls.SUBTREE_SCOPE);

      // Perform the search
      NamingEnumeration results = 
                      ctx.search(MY_CUSTOMER_BASE, "customerid=" + customerid, constraints);

      Customer c = null;

      // Now step through the search results
      while (results != null && results.hasMore()) {
         SearchResult sr = (SearchResult) results.next();
         String dn = sr.getName();

         Attributes attrs = sr.getAttributes();
         Attribute attr = attrs.get("givenname");
         String givenname = (String) attr.get();

         attr = attrs.get("sn");
         String sn = (String) attr.get();

         attr = attrs.get("ou");
         String ou = (String) attr.get();

         attr = attrs.get("mail");
         String mail = (String) attr.get();

         attr = attrs.get("telephonenumber");
         String telephone = (String) attr.get();

         attr = attrs.get("facsimiletelephonenumber");
         String fax = (String)attr.get();

         // Build a new Customer object with the attributes retrieved from the LDAP server  
         c = new Customer(dn, customerid, givenname, sn, ou, mail, telephone, fax);
      }
      return c;
   }

   protected void printCustomerPackages (Customer c,PrintWriter out) throws NamingException {
      out.println("<hr>");
      out.println("<b>Shipped Packages:</b><br>");
      out.println("<font color=#FF0000>Click on Package Id to see where your package is</font>");

      Hashtable env = new Hashtable();  

      env.put(Context.INITIAL_CONTEXT_FACTORY, INITCTX);
      env.put(Context.PROVIDER_URL, MY_HOST);

      // Get a reference to a directory context
      DirContext ctx = new InitialDirContext(env);

      SearchControls constraints = new SearchControls();
      constraints.setSearchScope(SearchControls.SUBTREE_SCOPE);
      log("Customer Name " + c.getNameInNamespace());

      NamingEnumeration results = 
                      ctx.search(MY_PACKAGE_BASE,"(|(receiveid=customerid="+c.getNameInNamespace()+","+MY_CUSTOMER_BASE+")(shipperid=customerid="+c.getNameInNamespace()+","+MY_CUSTOMER_BASE+"))",constraints);

      while (results != null && results.hasMore()) {
         SearchResult sr = (SearchResult) results.next();
         String dn = sr.getName();
         Attributes attrs = sr.getAttributes();
	   
         out.println("<ul>");

         Attribute attr = attrs.get("packageid");
         String packageid = (String) attr.get();
         out.println("<li>package id:<a href=\"CustomerServlet?packageid="+packageid+"\">"+packageid+"</a>");

         attr = attrs.get("shipperid");
         String shipperid = (String) attr.get();
         out.println("<li>shipper id:"+shipperid);

         attr = attrs.get("receiveid");
         String receiveid = (String) attr.get();
         out.println("<li>recipient id:"+receiveid);

         attr = attrs.get("shipdate");
         String shipdate = (String) attr.get();
         out.println("<li>date shipped:"+shipdate);

         try {
            // Not all packages will have a receivedate 
            attr = attrs.get("receivedate");
            String receivedate = (String) attr.get();
            out.println("<li>date recieved:"+receivedate);
         } catch(NullPointerException n) { }

         out.println("</ul><hr>");
      }
   }
     
   protected void packageLocation(String packageid, PrintWriter out) throws NamingException {
      Hashtable env = new Hashtable();

      // Get Java object 
      env.put(Context.INITIAL_CONTEXT_FACTORY, INITCTX);
      env.put(Context.PROVIDER_URL, MY_HOST);
 
      // Get a reference to a directory context
      DirContext ctx = new InitialDirContext(env);

      out.println("<hr><b>Package Location:</b><br>");

      // Now get Java object
      PackageLocation wip = (PackageLocation) ctx.lookup("cn=PackageLocation,ou=Java,o=fedup.com");

      out.println(wip.getLocation(packageid)+"<br>");
      out.println("<hr>");
      out.println("<a href=\"CustomerServlet\">Return to FedUp Customer Service</a>");
   }

   protected void printAddPackageForm(String customerid,PrintWriter out) {
      out.println("<form name=\"addpackage\" method=\"POST\" action=\"CustomerServlet\">");
      out.println("<table border=0>");
      out.println("<tr><td>Package Sender:</td><td>"+customerid+"<input type=\"hidden\" name=\"sender\" value=\""+customerid+"\"></td></tr>");
      out.println("<tr><td>Package Recipient:</td><td><input name=\"receiver\"></td></tr>");
      out.println("<tr><td><input type=\"submit\"></td><td></td></tr>");
      out.println("</table></form>");
   }

   protected void addNewPackage(String shipperid, String receiverid,PrintWriter out) throws NamingException, ParseException {
      Hashtable env = new Hashtable();  

      env.put(Context.INITIAL_CONTEXT_FACTORY, INITCTX);
      env.put(Context.PROVIDER_URL, MY_HOST);
      env.put(Context.SECURITY_AUTHENTICATION,"simple");
      env.put(Context.SECURITY_PRINCIPAL,MY_MGR);
      env.put(Context.SECURITY_CREDENTIALS,MY_PWD);

      // We must be authenticated as a user with "write" privileges.
      // We'll logon as an account on behalf of the customer.

      // Get a reference to a directory context
      DirContext ctx = new InitialDirContext(env);

      // Now Create a Package object so that we can store in the LDAP server
      // Get package id
      String packageid = new String(new Integer(nextPackageID++).toString());

      String dn = "packageid="+packageid + "," + MY_PACKAGE_BASE;

      String shipperdn = "customerid=" + shipperid + "," + MY_CUSTOMER_BASE;
      String receiverdn = "customerid=" + receiverid + "," + MY_CUSTOMER_BASE;

      // Get timestamp in LDAP time format:
      // 19990501024738Z
      DateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
      TimeZone tz = TimeZone.getTimeZone("GMT"); 
      format.setTimeZone(tz);
      Calendar cal = Calendar.getInstance();
      Date now = new Date();
      cal.setTimeZone(tz);
      cal.setTime(now);

      String shipdate = format.format(cal.getTime())+"Z";

      out.println("<hr><b>Package Information:</b><br>");
      out.println("<ul>");
      out.println("<li>shipperid: " + shipperid);
      out.println("<li>receiverid: " + receiverid);
      out.println("<li>packageid: " + packageid);
      out.println("<li>shipdate is " + shipdate);
      out.println("</ul>");

      Package p = new Package (dn,packageid,receiverdn,shipperdn,shipdate);

      //now add Package to the LDAP server
      ctx.bind(dn,p);
      out.println("<font color=\"#FF0000\"><b>Package Shipped!</b></font><hr>");
      out.println("<a href=\"CustomerServlet\">Back to FedUp Customer Service</a>");
   }
}