//Import Servlet Libraries
import javax.servlet.*;
import javax.servlet.http.*;

//Import Java Libraries
import java.io.*;
import java.util.*;

//Import SMTP Class
import sun.net.smtp.SmtpClient;

//Import html helper class
import com.wrox.util.*;

public class TechSupport extends HttpServlet {

   String message, msgFrom, msgTo, msgSubject;

   public void doPost(HttpServletRequest req, HttpServletResponse res)
      throws ServletException, IOException {

      res.setContentType("text/html");
      PrintWriter out = res.getWriter();

      getParameters(req);

      if(!sendMail()) {
         res.sendError(res.SC_INTERNAL_SERVER_ERROR, 
                "An error occurred while attempting to access the mail server.");
         return;
      }

      //Send acknowledgment to the browser
      HTML h = new HTML("XYZ Corporation IT Department");
      h.add(HTML.HEADING, "Your request has been submitted", false);
      out.println(h.getPage());
      out.close();
   }

   private void getParameters(HttpServletRequest req)
            throws ServletException, IOException
   {
      StringBuffer tempStringBuffer = new StringBuffer(1024);

      msgSubject = "Tech Support Request";
      msgTo = "tech@xyz.com";

      msgFrom = req.getParameter("txtEmail");

      tempStringBuffer.append("From: ");
      tempStringBuffer.append(req.getParameter("txtFirst"));
      tempStringBuffer.append(" ");
      tempStringBuffer.append(req.getParameter("txtLast"));
      tempStringBuffer.append("\n");
      tempStringBuffer.append("Phone: ");
      tempStringBuffer.append(req.getParameter("txtPhone"));
      tempStringBuffer.append("\n");
      tempStringBuffer.append("Email: ");
      tempStringBuffer.append(req.getParameter("txtEmail"));
      tempStringBuffer.append("\n\n");
      tempStringBuffer.append("Software: ");
      tempStringBuffer.append(req.getParameter("ddlb_software"));
      tempStringBuffer.append("\n");
      tempStringBuffer.append("OS: ");
      tempStringBuffer.append(req.getParameter("ddlb_os"));    
      tempStringBuffer.append("\n\n");
      tempStringBuffer.append("Problem: ");
      tempStringBuffer.append(req.getParameter("txtProblem"));
      tempStringBuffer.append("\n");

      message = tempStringBuffer.toString();
   }

   private boolean sendMail()
   {

      PrintStream out;
      SmtpClient send;

      try
      {
         //  Replace the following with your outgoing mail server name
         send = new SmtpClient("mail.xyz.com");
         send.from(msgFrom);
         send.to(msgTo);

         out = send.startMessage();
  
         out.println("From: " + msgFrom);
         out.println("To: " + msgTo);
         out.println("Subject: " + msgSubject);

         out.println("\n-----------------------\n");

         out.println(message);
         out.println("\r\n");
         out.println("\n-----------------------\n");
         out.flush();
         out.close();
         send.closeServer();
      }
      catch (IOException e) {
         log("Error occurred while sending mail", e);
         return false;
      }
      return true
   }

}
