import javax.servlet.*;
import javax.servlet.http.*;

import java.io.*;
import java.util.*;

import com.wrox.util.*;

public class Cart extends HttpServlet 
{

   /* View items in shopping cart */
   public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException 
   {

      res.setContentType("text/html");
      PrintWriter out = res.getWriter();

      HTML h = new HTML("Contents of your shopping cart");
      h.add(HTML.HEADING, "Your Shopping Cart Contains...", false);
      h.add(HTML.LINE, "", true);

      /* Read in Cookies */
      Cookie cookies[];

      cookies = req.getCookies();
      if (cookies != null) 
      {
         for (int i = 0; i &lt; cookies.length; i++) 
         {
            if (cookies[i].getName().startsWith("sku")) 
            {
               h.add(HTML.NORMAL, cookies[i].getName(), false);
               h.add(HTML.NORMAL, " : ", false);
               h.add(HTML.NORMAL, cookies[i].getValue(), true);
               h.add(HTML.NORMAL, "", true); //Extra Line Break
            }
         }
      }

      out.println(h.getPage());
      out.close();
   }

   /* Edit items in shopping cart */
   public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException 
   {

      res.setContentType("text/html");
      Cookie c = new Cookie("null", "null");

      /* Retrieve Form Data */
      Enumeration keys;
      String key, value;
      keys = req.getParameterNames();
      while (keys.hasMoreElements())
      {
         key = (String)keys.nextElement();
         value = req.getParameter(key);
         if (value.substring(0,3).equals("sku")) 
         {
            if (value.equals("sku_100")) 
            {
               c = new Cookie(value, "Premium Graphite Tennis Raquet (Oversize) - " + req.getParameter("p_sku_100"));
            }
            if (value.equals("sku_200")) 
            {
               c = new Cookie(value, "300lb Olympic Weightset - " + req.getParameter("p_sku_200"));
            }
            if (value.equals("sku_300")) 
            {
               c = new Cookie(value, "10 - 12 Person Deluxe Cabin Tent - " + req.getParameter("p_sku_300"));
            }
            c.setMaxAge(2*24*60*60);    //Expires in 2 days
            res.addCookie(c);
         }
      }


      /* Send a redirect to send the cookies and return
      a GET request to view the items in the cart */
      res.sendRedirect("http://localhost:8080/servlet/Cart");

   }
}

