import javax.servlet.*;
import javax.servlet.http.*;

import java.io.*;
import java.util.*;

import com.wrox.util.*;

import com.sun.server.util.regexp.*;

public class Regexp extends HttpServlet
{
   public void doGet(HttpServletRequest _req, HttpServletResponse _res)
   throws ServletException, IOException
   {

   _res.setContentType("text/html");
   PrintWriter out = _res.getWriter();

   HTML h = new HTML("Regular Expressions");
   h.add(HTML.HEADING, "Results of Regular Expression Operation", false);
   h.add(HTML.LINE, "", true);

   /* Read in the form values */
   String caseFlag = "N";
   String exp = _req.getParameter("exp");
   String str = _req.getParameter("str");
   Enumeration e = _req.getParameterNames();
   while(e.hasMoreElements()){
      if (e.nextElement().equals("caseFlag"))
      {
      caseFlag = _req.getParameter("caseFlag");
      }
   }

   /* Display original expression and string */
   h.add(HTML.NORMAL, "Expression: ", false);
   h.add(HTML.NORMAL, exp, true);
   h.add(HTML.NORMAL, "String: ", false);
   h.add(HTML.NORMAL, str, true);
   if (caseFlag.equals("Y"))
   {
   h.add(HTML.NORMAL, "Match Flags: Ignore Case", true);
   }
   else
   {
   h.add(HTML.NORMAL, "Match Flags: Normal", true);
   }

   /* Create and execute regular expression */
   try
   {
   RE r = new RE(exp);
      if (caseFlag.equals("Y"))
      {
      r.setMatchFlags(1);
      }
      else
      {
      r.setMatchFlags(0);
      }
      if (r.match(str))
      {
      /* Check for parenthesized results */
      int i = r.getParenCount();
         if (i > 1)
         {
         h.add(HTML.NORMAL, "Parenthesized Results:", true);
            for (int x = 0; x < i; x++)
            {
            h.add(HTML.NORMAL, r.getParen(x), true);
            }
         }
      else
      {
      h.add(HTML.NORMAL, "Match :)", true);
      }
   }
   else
   {
   h.add(HTML.NORMAL, "No Match :(", true);
   }
   }
   catch (RESyntaxException ex)
   {
   h.add(HTML.NORMAL, "Syntax error in expression.", true);
   }

    out.println(h.getPage());
    out.close();
   }
}

