import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;

/** 
 * This class serves as an administrative tool maintaining a serialized Hashtable.
 * @version 1.5 
 */

public class SiteAdmin extends HttpServlet 
{    
    private String header = "<html><head><title>TallCoin Site Administration</title></head><body>\n";
    private String footer = "</body></html>\n";    
    private String validUser;
    private String validPasswd;
    private String configFile;

/**
 * Init
 */
    public void init(ServletConfig config)
    {
        validUser = config.getInitParameter("validUser");
        validPasswd = config.getInitParameter("validPasswd");
        configFile = config.getInitParameter("configParms");
    }
		
/** 
 * This method handles all http requests to the servlet
 * @param HttpServletRequest request
 * @param HttpServletResponse response
 * @exception IOException IO Exception
 * @return void
 */
    public void service(HttpServletRequest request, HttpServletResponse response) 
        throws IOException
    {
        String action = request.getPathInfo();

        // handle special case of null action
        if (action == null)
        {
            doLogin(request, response);
            return;
        }

        // strip the leading slash off action
        if (action.startsWith("/")) action = action.substring(1);

        if (action.equals("display.html"))
            { doDisplay(request, response); }
        else if (action.equals("save.html"))
            { doSave(request, response); }    
        else if (action.equals("add.html"))
            { doAdd(request, response);  }
        else if (action.equals("delete.html"))
            { doDelete(request, response);  }
        else
            { doLogin(request, response); }
    } // end service
    
    
/** 
 * This method displays the html form used for authenticating users.
 * @param HttpServletRequest req
 * @param HttpServletResponse res
 * @exception IOException IO Exception
 * @return void
 */
    public void doLogin(HttpServletRequest req, HttpServletResponse res)
        throws IOException
    {
        HttpSession session = req.getSession(true); 
      
        res.setContentType("text/html");
        PrintWriter out = res.getWriter();    
        StringBuffer HTML = new StringBuffer();
        
        HTML.append(header);
        HTML.append("<center>\n");
        HTML.append("<table border=0 width=1>\n");
        HTML.append("  <tr>\n");
        HTML.append("    <td bgcolor='1111aa'>\n");
        HTML.append("      <table border=1 width=300>\n");
        HTML.append("        <tr>\n");
        HTML.append("          <td align=center bgcolor='cacaca'>\n");
        HTML.append("            <b>Please Log In:</b>\n");
        HTML.append("          </td>\n");
        HTML.append("        </tr>\n");
        HTML.append("        <tr>\n");
        HTML.append("          <td align=center bgcolor='ffffff'>\n");
        HTML.append("            <form action='/servlet/SiteAdmin/display.html' method='post'>\n");
        HTML.append("              <table border=0>\n");
        HTML.append("                <tr>\n");
        HTML.append("                  <td>User: </td>\n");
        HTML.append("                  <td><input name='userId'></td>\n");
        HTML.append("                </tr>\n");
        HTML.append("                <tr>\n");
        HTML.append("                  <td>Password: </td>\n");
        HTML.append("                  <td><input type=password name='password' maxlength=9></td>\n");
        HTML.append("                </tr>\n");
        HTML.append("                <tr>\n");
        HTML.append("                  <td colspan=2 align=center><p><input type=submit value='Log In'></td>\n");
        HTML.append("                </tr>\n");
        HTML.append("              </table>\n");
        HTML.append("            </form>\n");
        HTML.append("          </td>\n");
        HTML.append("        </tr>\n");
        HTML.append("      </table>\n");
        HTML.append("    </td>\n");
        HTML.append("  </tr>\n");
        HTML.append("</table>\n"); 
        HTML.append("</center>\n");   
        HTML.append(footer);            
        out.println(HTML.toString());  
        
        session.putValue("note","");        
        
    } // end doLogin
    
/** 
 * This method displays the html form used to set the values of the parameters.
 * @param HttpServletRequest req
 * @param HttpServletResponse res
 * @exception IOException IO Exception
 * @return void
 */
    public void doDisplay(HttpServletRequest req, HttpServletResponse res)
        throws IOException
    {
        HttpSession session = req.getSession(false); 
      
        res.setContentType("text/html");
        PrintWriter out = res.getWriter();    
        StringBuffer HTML = new StringBuffer();
        
        String userId   = req.getParameter("userId");
        String password = req.getParameter("password");
        
        if (userId==null) { userId = (String)session.getValue("userId"); }
        if (password==null) { password = (String)session.getValue("password"); }
        
        if (!userId.equals(validUser) || !password.equals(validPasswd))
        {
            doLogin(req,res);
            return;
        }
        session.putValue("userId",userId);
        session.putValue("password",password);
     
        String note = (String)session.getValue("note");
        if (note==null) { note = ""; }

        HTML.append(header);
        HTML.append("<center>\n");
        HTML.append(note);
        HTML.append("<table border=0 width=1>\n");
        HTML.append("  <tr>\n");
        HTML.append("    <td bgcolor='1111aa'>\n");
        HTML.append("      <table border=1 width=300>\n");
        HTML.append("        <tr>\n");
        HTML.append("          <td align=center bgcolor='dddddd'>\n");
        HTML.append("            <form action='save.html' method=post>\n");        
        HTML.append("            <table border=0>\n");
        
        Hashtable parmTable = fileToHashtable(configFile);      
        for (Enumeration parameters = parmTable.keys(); parameters.hasMoreElements();)
        {
            String parameter = (String)parameters.nextElement();
            String value     = (String)parmTable.get(parameter);
            
            HTML.append("              <tr>\n");
            HTML.append("                <td><b>"+parameter+":</b> </td>\n");
            HTML.append("                <td><input size=50 name="+parameter+" value='"+value+"'></td>\n");
            HTML.append("                <td><a href='delete.html?x="+parameter+"'>delete</a></td>\n");
            HTML.append("              </tr>\n");
        }
        
        HTML.append("              <tr>\n");
        HTML.append("                <td colspan=2 align=center><input type=submit value='Save'></td>\n");
        HTML.append("                </form>\n");
        HTML.append("              </tr>\n");
        HTML.append("              <tr>\n");
        HTML.append("                <form action='add.html' method=post>\n");
        HTML.append("                <td><input size=20 name=name value='name'></td>\n");
        HTML.append("                <td><input size=50 name=value value='value'></td>\n");
        HTML.append("                <td><input type=submit value='Add'></td>\n");
        HTML.append("                </form>\n");
        HTML.append("              </tr>\n");
        HTML.append("            </table>\n");
        HTML.append("          </td>\n");
        HTML.append("        </tr>\n");
        HTML.append("      </table>\n");
        HTML.append("    </td>\n");
        HTML.append("  </tr>\n");
        HTML.append("</table>\n");
        HTML.append("</center>\n");
        HTML.append(footer);
        out.println(HTML.toString());        
    }
    
/** 
 * This method sets the values for all of the parameters as specified.
 * @param HttpServletRequest req
 * @param HttpServletResponse res
 * @exception IOException IO Exception
 * @return void
 */
    public void doSave(HttpServletRequest req, HttpServletResponse res)
        throws IOException
    {
        HttpSession session   = req.getSession(true); 
        Hashtable   parmTable = new Hashtable();
        
        String userId   = (String)session.getValue("userId");
        String password = (String)session.getValue("password");
        
        if (!userId.equals(validUser) || !password.equals(validPasswd))
        {
            doLogin(req,res);
            return;
        }
        
        for (Enumeration parms = req.getParameterNames(); parms.hasMoreElements();)
        {
            String parameter = parms.nextElement().toString();
            String value     = req.getParameter(parameter);
            
            parmTable.put(parameter,value);
        } 

        hashtableToFile(parmTable, configFile);
        
        session.putValue("note","<b>Parameters saved.</b>\n");
        
        doDisplay(req, res);
        
    } // end doSave
    
    
/** 
 * This method adds a parameter/value pair.
 * @param HttpServletRequest req
 * @param HttpServletResponse res
 * @exception IOException IO Exception
 * @return void
 */
    public void doAdd(HttpServletRequest req, HttpServletResponse res)
        throws IOException    
    {  
        HttpSession session   = req.getSession(true); 
        Object o = null;   
        
        String userId   = (String)session.getValue("userId");
        String password = (String)session.getValue("password");
        
        if (!userId.equals(validUser) || !password.equals(validPasswd))
        {
            doLogin(req,res);
            return;
        }     

        Hashtable parmTable = fileToHashtable(configFile);
        
        String parameter = req.getParameter("name");
        String value     = req.getParameter("value");
        
        parmTable.put(parameter,value);
    
        hashtableToFile(parmTable, configFile);
        
        session.putValue("note","<b>Parameter added.</b>\n");
        
        doDisplay(req, res);
        
    } // end doAdd
   
    
/** 
 * This method deletes a parameter/value pair.
 * @param HttpServletRequest req
 * @param HttpServletResponse res
 * @exception IOException IO Exception
 * @return void
 */
    public void doDelete(HttpServletRequest req, HttpServletResponse res)
        throws IOException
    {
        HttpSession session   = req.getSession(false);  
        
        String userId   = (String)session.getValue("userId");
        String password = (String)session.getValue("password");
        
        if (!userId.equals(validUser) || !password.equals(validPasswd))
        {
            doLogin(req,res);
            return;
        }      

        Hashtable parmTable = fileToHashtable(configFile);
        
        String parameter = req.getParameter("x");
        parmTable.remove(parameter);
    
        hashtableToFile(parmTable, configFile);
        
        session.putValue("note","<b>Parameter deleted.</b>\n");        
        
        doDisplay(req, res);
        
    } // end doDelete 
   
   
/** 
 * This method retrieves the hashtable from the serialized file.
 * @param String cfgFile
 * @exception IOException IO Exception
 * @return void
 */
    public Hashtable fileToHashtable(String cfgFile)
    {
        Hashtable parmTable = new Hashtable();
        Object o = null;                        

        try        
        {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(cfgFile));
            o = in.readObject();
        }    
    
        catch(Exception e)
        {
            System.out.println(e.toString());
        }        
        
        if (o instanceof Hashtable)  
        {
            parmTable = (Hashtable)o;     
        }
        
        return parmTable;
        
    } // end fileToHashtable
        
        
/** 
 * This method writes the hashtable to the serialized file.
 * @param Hashtable parms 
 * @param String cfgFile
 * @exception IOException IO Exception
 * @return void
 */             
    public void hashtableToFile(Hashtable parms, String cfgFile)
    {
        try 
        {
            ObjectOutputStream out = new ObjectOutputStream( new FileOutputStream(cfgFile));
            out.writeObject(parms);
            out.close();
        }
        catch (Exception e) 
        {
            e.printStackTrace();
        }
    } // end hashtableToFile
           
}