//Import Servlet Libraries
import javax.servlet.*;
import javax.servlet.http.*;

//Import Java Libraries
import java.io.*;

//Import html and loan helper classes
import com.wrox.util.*;

public class LoanCalculator extends HttpServlet
{
   public void doGet(HttpServletRequest req, HttpServletResponse res)
       throws ServletException, IOException
   {

      //  retrieve parameter values as strings
      String principalAsString = req.getParameter("principal");
      String interestAsString = req.getParameter("interest");
      String paymentAsString = req.getParameter("payment");

      //  initialize variables to hold floating point values
      float principal, interest, payment;

      //  initialize a variable to hold the loan repayment period
      int months;

      try
      {
         //  use the LoanTools class to obtain floating point values
         //  stringToFloat throws a NumberFormatException, so we'll have to catch it
         principal = LoanTools.stringToFloat(principalAsString);
         interest = LoanTools.stringToFloat(interestAsString);
         payment = LoanTools.stringToFloat(paymentAsString);

         //  use the LoanTools class to calculate the loan period
         //  the method throws an IllegalArgumentException, so we'll have to catch it
         months = LoanTools.calculateLoanPeriod(principal, interest, payment);
      }

      //  If a NumberFormatException was thrown, we want to
      //  replace the error message with something more friendly
      catch (NumberFormatException e)
      {
         handleError(new NumberFormatException("Check that the values entered are numeric"), res);
         return;
      }

      //  If any other kind of exception was thrown, we catch it here
      catch (Exception e)
      {
         handleError(e, res);
         return;
      }

      //  If no exceptions were thrown, the code continues here
      //  so we can send an acknowledgment to the browser

      res.setContentType("text/html");
      PrintWriter out = res.getWriter();

      HTML h = new HTML("Loan Calculator: Results");
      h.add(HTML.HEADING, "Loan Calculator Results", false);
      h.add(HTML.LINE, "", false);
      h.add(HTML.NORMAL, "Principal Amount: $", false);
      h.add(HTML.NORMAL, Float.toString(principal), true);
      h.add(HTML.NORMAL, "Interest:  ", false);
      h.add(HTML.NORMAL, Float.toString(interest), true);
      h.add(HTML.NORMAL, "Payment: $", false);
      h.add(HTML.NORMAL, Float.toString(payment), true);
      h.add(HTML.NORMAL, "Months Until Payoff: ", false);
      h.add(HTML.NORMAL, Integer.toString(months), true);
      out.println(h.getPage());
      out.close();

      //    The following lines demonstrate logging via the ServletContext log() method
//    ServletContext sc = getServletContext();
//    sc.log("Loan period calculated: " + Integer.toString(months));

      //    The following line demonstrates logging via the GenericServlet log() method
//    log("Loan period calculated: " + Integer.toString(months));

   }

   //     This version of handleError() sends plain HTML to inform
   //     the client of the error
   private void handleError(Exception e, HttpServletResponse res)
   {

   //     You can use res.setStatus() here to inform the client's browser that
   //     this response represents an error, not a successful request
//    res.setStatus(400);
   
      res.setContentType("text/html");
      PrintWriter out = res.getWriter();

      HTML h = new HTML("Loan Calculator: Error");
      h.add(HTML.HEADING, "An error has occured...", false);
      h.add(HTML.LINE, "", false);
      h.add(HTML.NORMAL, e.getMessage(), false);
      out.println(h.getPage());
      out.close();
   }
   
   //     This version of handleError() sends an HTTP Error code to inform
   //     the client and server of the error
// private void handleError(Exception e, HttpServletResponse res)
//           throws IOException
// {
//      res.sendError(400, e.getMessage());
// }

   //     This version of handleError() throws a ServletException to inform
   //     the client and server of the error
// private void handleError(Exception e, HttpServletResponse res)
//           throws ServletException
// {
//      throw new ServletException("Error in Loan Calculator Servlet",e);
// }

}
