//Import Servlet Libraries
import javax.servlet.*;
import javax.servlet.http.*;

//Import Java Libraries
import java.util.*;
import java.sql.*;
import java.io.*;

public class DbServlet extends HttpServlet {

   Connection dbCon;

   public void init() throws ServletException {

      try {
         Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
         String dbURL = "jdbc:odbc:projects";
         dbCon = DriverManager.getConnection(dbURL);
      } catch (Exception e) {
         System.out.println("Database connect failed (init)");
         System.out.println(e.toString());
         return;
      }
   }

   public void doGet(HttpServletRequest req, HttpServletResponse res)
      throws ServletException, IOException {

      PrintWriter out = res.getWriter();
      res.setContentType("text/html");

      String qry = req.getParameter("qry");

      try {
         Statement s = dbCon.createStatement();
         ResultSet rs = s.executeQuery(qry);
         while (rs.next()) {
            out.println(rs.getString(1) + " -  " + rs.getString(2));
            out.println(rs.getString(3));
            out.println ("");
         }
      } catch (SQLException e) {
         System.out.println(e.toString());
         return;
      }
      out.println();
      out.close();
   }

   public void destroy() {

      /* Close database connection */
      try {
         dbCon.close();
      } catch (Exception e) {
         System.out.println("Error closing database (destroy)");
         System.out.println(e.toString());
      }
   }
}
